/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.AbstractConstraint;
import org.apache.flink.table.catalog.Constraint;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class UniqueConstraint
extends AbstractConstraint {
    private final List<String> columns;
    private final Constraint.ConstraintType type;

    public static UniqueConstraint primaryKey(String name, List<String> columns) {
        return new UniqueConstraint(name, false, Constraint.ConstraintType.PRIMARY_KEY, columns);
    }

    private UniqueConstraint(String name, boolean enforced, Constraint.ConstraintType type, List<String> columns) {
        super(name, enforced);
        this.columns = (List)Preconditions.checkNotNull(columns);
        this.type = (Constraint.ConstraintType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
    }

    public List<String> getColumns() {
        return this.columns;
    }

    private String getTypeString() {
        switch (this.getType()) {
            case PRIMARY_KEY: {
                return "PRIMARY KEY";
            }
            case UNIQUE_KEY: {
                return "UNIQUE";
            }
        }
        throw new IllegalStateException("Unknown key type: " + this.getType());
    }

    @Override
    public Constraint.ConstraintType getType() {
        return this.type;
    }

    @Override
    public final String asSummaryString() {
        return String.format("CONSTRAINT %s %s (%s)%s", EncodingUtils.escapeIdentifier(this.getName()), this.getTypeString(), this.columns.stream().map(EncodingUtils::escapeIdentifier).collect(Collectors.joining(", ")), this.isEnforced() ? "" : " NOT ENFORCED");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UniqueConstraint that = (UniqueConstraint)o;
        return Objects.equals(this.columns, that.columns) && this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.columns, this.type});
    }
}

