/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.SessionManager;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DMessageCache;
import flash.tools.debugger.concrete.DMessageCounter;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.EnumMap;

public class DProtocol
implements Runnable {
    public static final int DEBUG_PORT = 7935;
    public static final int DEBUG_CONNECT_PORT = 7936;
    private final BufferedInputStream m_in;
    private final BufferedOutputStream m_out;
    private final EnumMap<ListenerIndex, DProtocolNotifierIF> m_listeners;
    private long m_msgRx;
    private long m_msgTx;
    private volatile boolean m_stopRx;
    private volatile Thread m_rxThread;
    private volatile Exception m_disconnectCause;
    private volatile Socket m_socket;
    private boolean m_detectBrokenSocket;

    public DProtocol(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) {
        this.m_in = bufferedInputStream;
        this.m_out = bufferedOutputStream;
        this.m_listeners = new EnumMap(ListenerIndex.class);
        this.m_msgRx = 0L;
        this.m_msgTx = 0L;
        this.m_stopRx = false;
        this.m_rxThread = null;
        this.m_socket = null;
        this.m_detectBrokenSocket = false;
        this.addListener(ListenerIndex.MessageCounter, new DMessageCounter());
    }

    public DProtocol(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, Socket socket, boolean bl) {
        this(bufferedInputStream, bufferedOutputStream);
        this.m_socket = socket;
        this.m_detectBrokenSocket = bl;
    }

    static void applyBaseSocketSettings(Socket socket) throws SocketException {
        socket.setTcpNoDelay(true);
    }

    static DProtocol createDProtocolFromSocket(Socket socket, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
        DProtocol dProtocol = new DProtocol(bufferedInputStream, bufferedOutputStream, socket, bl);
        return dProtocol;
    }

    static DProtocol createFromSocket(Socket socket) throws IOException {
        DProtocol.applyBaseSocketSettings(socket);
        return DProtocol.createDProtocolFromSocket(socket, false);
    }

    static DProtocol createFromSocket(Socket socket, SessionManager sessionManager) throws IOException {
        DProtocol.applyBaseSocketSettings(socket);
        int n = sessionManager.getPreference("$sockettimeout");
        boolean bl = false;
        if (n > 0) {
            socket.setSoTimeout(n);
            bl = true;
        }
        return DProtocol.createDProtocolFromSocket(socket, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ListenerIndex listenerIndex, DProtocolNotifierIF dProtocolNotifierIF) {
        EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
        synchronized (enumMap) {
            this.m_listeners.put(listenerIndex, dProtocolNotifierIF);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messagesReceived() {
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            return this.m_msgRx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messagesSent() {
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            return this.m_msgTx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DProtocolNotifierIF[] dProtocolNotifierIFArray;
        block8: {
            try {
                this.m_stopRx = false;
                this.listenForMessages();
            }
            catch (Exception exception) {
                this.m_disconnectCause = exception;
                if (!Trace.error || exception instanceof SocketException && exception.getMessage().equalsIgnoreCase("socket closed")) break block8;
                exception.printStackTrace();
            }
        }
        EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
        synchronized (enumMap) {
            dProtocolNotifierIFArray = this.m_listeners.values().toArray(new DProtocolNotifierIF[this.m_listeners.size()]);
        }
        for (int i = 0; i < dProtocolNotifierIFArray.length; ++i) {
            DProtocolNotifierIF dProtocolNotifierIF = dProtocolNotifierIFArray[i];
            try {
                dProtocolNotifierIF.disconnected();
                continue;
            }
            catch (Exception exception) {
                if (!Trace.error) continue;
                exception.printStackTrace();
            }
        }
        this.m_rxThread = null;
        this.m_socket = null;
    }

    public boolean bind() {
        boolean bl = true;
        if (this.m_rxThread == null) {
            this.getMessageCounter().clearInCounts();
            this.getMessageCounter().clearOutCounts();
            this.m_rxThread = new Thread((Runnable)this, "DJAPI message listener");
            this.m_rxThread.setDaemon(true);
            this.m_rxThread.start();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean unbind() {
        boolean bl = true;
        if (this.m_rxThread == null) {
            bl = false;
        } else {
            this.m_stopRx = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listenForMessages() throws IOException {
        DProtocolNotifierIF[] dProtocolNotifierIFArray = new DProtocolNotifierIF[]{};
        while (!this.m_stopRx) {
            try {
                DMessage dMessage = this.rxMessage();
                EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
                synchronized (enumMap) {
                    dProtocolNotifierIFArray = this.m_listeners.values().toArray(dProtocolNotifierIFArray);
                }
                for (int i = 0; i < dProtocolNotifierIFArray.length; ++i) {
                    DProtocolNotifierIF dProtocolNotifierIF = dProtocolNotifierIFArray[i];
                    try {
                        dProtocolNotifierIF.messageArrived(dMessage, this);
                    }
                    catch (Exception exception) {
                        System.err.println("Error in listener parsing incoming message :");
                        System.err.println(dMessage.inToString(16));
                        exception.printStackTrace();
                    }
                    dMessage.reset();
                }
                DMessageCache.free(dMessage);
            }
            catch (InterruptedIOException interruptedIOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void txMessage(DMessage dMessage) throws IOException {
        int n = dMessage.getSize();
        int n2 = dMessage.getType();
        this.writeDWord(n);
        this.writeDWord(n2);
        this.writeData(dMessage.getData(), n);
        this.m_out.flush();
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            ++this.m_msgTx;
        }
        this.getMessageCounter().messageSent(dMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMessage rxMessage() throws IOException {
        int n = -1;
        int n2 = 0;
        try {
            n = (int)this.readDWord();
            n2 = (int)this.readDWord();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            long l;
            if (!this.m_detectBrokenSocket) {
                throw socketTimeoutException;
            }
            int n3 = -1;
            if (this.m_socket != null) {
                n3 = this.m_socket.getSendBufferSize();
                this.m_socket.setSendBufferSize(1);
            }
            SendThread sendThread = new SendThread();
            sendThread.start();
            long l2 = System.currentTimeMillis();
            do {
                try {
                    sendThread.join(1000L);
                    if (!sendThread.completed) continue;
                }
                catch (InterruptedException interruptedException) {}
                break;
            } while ((l = System.currentTimeMillis()) - l2 <= 10000L);
            boolean bl = true;
            if (sendThread.isAlive()) {
                sendThread.interrupt();
                bl = false;
            }
            if (this.m_socket != null && n3 > 0) {
                this.m_socket.setSendBufferSize(n3);
            }
            if (!sendThread.completed) {
                bl = false;
            }
            if (sendThread.exception != null) {
                throw sendThread.exception;
            }
            if (bl) {
                throw socketTimeoutException;
            }
            throw new SocketException("Broken pipe");
        }
        if (n < 0) {
            throw new IOException("socket closed");
        }
        DMessage dMessage = DMessageCache.alloc(n);
        byte[] byArray = dMessage.getData();
        for (int i = 0; i < n; i += this.m_in.read(byArray, i, n - i)) {
        }
        dMessage.setType(n2);
        DProtocol dProtocol = this;
        synchronized (dProtocol) {
            ++this.m_msgRx;
        }
        return dMessage;
    }

    void writeDWord(long l) throws IOException {
        byte by = (byte)(l & 0xFFL);
        byte by2 = (byte)(l >> 8 & 0xFFL);
        byte by3 = (byte)(l >> 16 & 0xFFL);
        byte by4 = (byte)(l >> 24 & 0xFFL);
        this.m_out.write(by);
        this.m_out.write(by2);
        this.m_out.write(by3);
        this.m_out.write(by4);
    }

    void writeData(byte[] byArray, long l) throws IOException {
        if (l > 0L) {
            this.m_out.write(byArray, 0, (int)l);
        }
    }

    long readDWord() throws IOException {
        int n = this.m_in.read();
        int n2 = this.m_in.read();
        int n3 = this.m_in.read();
        int n4 = this.m_in.read();
        long l = n4 << 24 & 0xFF000000 | n3 << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n & 0xFF;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMessageCounter getMessageCounter() {
        EnumMap<ListenerIndex, DProtocolNotifierIF> enumMap = this.m_listeners;
        synchronized (enumMap) {
            return (DMessageCounter)this.m_listeners.get((Object)ListenerIndex.MessageCounter);
        }
    }

    public Exception getDisconnectCause() {
        return this.m_disconnectCause;
    }

    class SendThread
    extends Thread {
        public IOException exception = null;
        public volatile boolean completed = false;

        SendThread() {
        }

        @Override
        public void run() {
            try {
                DMessage dMessage = DMessageCache.alloc(4);
                dMessage.setType(24);
                dMessage.putDWord(1);
                DProtocol.this.txMessage(dMessage);
                DMessageCache.free(dMessage);
                this.completed = true;
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }
    }

    public static enum ListenerIndex {
        PlayerSession,
        MessageCounter;

    }
}

