/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Tag;
import flash.swf.TagHandler;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import java.util.HashMap;
import java.util.Map;

public class Dictionary {
    private static DefineTag INVALID_TAG = new DefineTag(0){

        @Override
        public void visit(TagHandler tagHandler) {
        }
    };
    Map<Integer, DefineTag> ids = new HashMap<Integer, DefineTag>();
    Map<DefineTag, Integer> tags = new HashMap<DefineTag, Integer>();
    Map<String, DefineTag> names = new HashMap<String, DefineTag>();
    Map<String, DefineFont> fonts = new HashMap<String, DefineFont>();
    private int nextId = 1;

    public boolean contains(int n) {
        return this.ids.containsKey(new Integer(n));
    }

    public boolean contains(DefineTag defineTag) {
        return this.tags.containsKey(defineTag);
    }

    public int getId(DefineTag defineTag) {
        if (defineTag == null || defineTag == INVALID_TAG) {
            return -1;
        }
        Integer n = this.tags.get(defineTag);
        if (n == null) {
            for (Map.Entry<Integer, DefineTag> entry : this.ids.entrySet()) {
                if (entry.getValue() != defineTag) continue;
                n = entry.getKey();
                break;
            }
        }
        if (n == null) assert (false) : "encoding error, " + defineTag.name + " not in dictionary";
        return n;
    }

    public int add(DefineTag defineTag) {
        assert (defineTag != null);
        Integer n = this.tags.get(defineTag);
        if (n != null) {
            return n;
        }
        Integer n2 = new Integer(this.nextId++);
        this.tags.put(defineTag, n2);
        this.ids.put(n2, defineTag);
        return n2;
    }

    public void add(int n, DefineTag defineTag) throws IllegalArgumentException {
        Integer n2 = new Integer(n);
        Tag tag = this.ids.get(n2);
        if (tag != null) {
            if (tag.equals(defineTag)) {
                throw new IllegalArgumentException("symbol " + n + " redefined by identical tag");
            }
            throw new IllegalArgumentException("symbol " + n + " redefined by different tag");
        }
        this.ids.put(n2, defineTag);
    }

    public void addName(DefineTag defineTag, String string) {
        this.names.put(string, defineTag);
    }

    private static String makeFontKey(String string, boolean bl, boolean bl2) {
        return string + (bl ? "_bold_" : "_normal_") + (bl2 ? "_italic" : "_regular");
    }

    public void addFontFace(DefineFont defineFont) {
        this.fonts.put(Dictionary.makeFontKey(defineFont.getFontName(), defineFont.isBold(), defineFont.isItalic()), defineFont);
    }

    public DefineFont getFontFace(String string, boolean bl, boolean bl2) {
        return this.fonts.get(Dictionary.makeFontKey(string, bl, bl2));
    }

    public boolean contains(String string) {
        return this.names.containsKey(string);
    }

    public DefineTag getTag(String string) {
        return this.names.get(string);
    }

    public DefineTag getTag(int n) throws IllegalArgumentException {
        Integer n2 = new Integer(n);
        DefineTag defineTag = this.ids.get(n2);
        if (defineTag == null) {
            if (n != 65535) {
                throw new IllegalArgumentException("symbol " + n + " not defined");
            }
            return INVALID_TAG;
        }
        return defineTag;
    }

    public void setNextId(int n) {
        this.nextId = n;
    }

    public int getNextId() {
        return this.nextId;
    }
}

