/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class ApproximateHistogramBufferAggregator
implements BufferAggregator {
    private final BaseFloatColumnValueSelector selector;
    private final ApproximateHistogramBufferAggregatorHelper innerAggregator;

    public ApproximateHistogramBufferAggregator(BaseFloatColumnValueSelector selector, int resolution) {
        this.selector = selector;
        this.innerAggregator = new ApproximateHistogramBufferAggregatorHelper(resolution);
    }

    public void init(ByteBuffer buf, int position) {
        this.innerAggregator.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        if (this.selector.isNull()) {
            return;
        }
        this.innerAggregator.aggregate(buf, position, this.selector.getFloat());
    }

    public Object get(ByteBuffer buf, int position) {
        return this.innerAggregator.get(buf, position);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getLong()");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getDouble()");
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (HotLoopCallee)this.selector);
    }
}

