/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.kerberos;

import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.security.kerberos.RetryResponseHolder;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class RetryIfUnauthorizedResponseHandler<Intermediate, Final>
implements HttpResponseHandler<RetryResponseHolder<Intermediate>, RetryResponseHolder<Final>> {
    private static final Logger log = new Logger(RetryIfUnauthorizedResponseHandler.class);
    private final HttpResponseHandler<Intermediate, Final> httpResponseHandler;

    public RetryIfUnauthorizedResponseHandler(HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
    }

    public ClientResponse<RetryResponseHolder<Intermediate>> handleResponse(HttpResponse httpResponse, HttpResponseHandler.TrafficCop trafficCop) {
        log.debug("UnauthorizedResponseHandler - Got response status [%s]", new Object[]{httpResponse.getStatus()});
        if (httpResponse.getStatus().equals((Object)HttpResponseStatus.UNAUTHORIZED)) {
            httpResponse.getContent().toString();
            return ClientResponse.unfinished(RetryResponseHolder.retry());
        }
        return this.wrap(this.httpResponseHandler.handleResponse(httpResponse, trafficCop));
    }

    public ClientResponse<RetryResponseHolder<Intermediate>> handleChunk(ClientResponse<RetryResponseHolder<Intermediate>> clientResponse, HttpChunk httpChunk, long chunkNum) {
        if (((RetryResponseHolder)clientResponse.getObj()).shouldRetry()) {
            httpChunk.getContent().toString();
            return clientResponse;
        }
        return this.wrap(this.httpResponseHandler.handleChunk(this.unwrap(clientResponse), httpChunk, chunkNum));
    }

    public ClientResponse<RetryResponseHolder<Final>> done(ClientResponse<RetryResponseHolder<Intermediate>> clientResponse) {
        if (((RetryResponseHolder)clientResponse.getObj()).shouldRetry()) {
            return ClientResponse.finished(RetryResponseHolder.retry());
        }
        return this.wrap(this.httpResponseHandler.done(this.unwrap(clientResponse)));
    }

    public void exceptionCaught(ClientResponse<RetryResponseHolder<Intermediate>> clientResponse, Throwable throwable) {
        this.httpResponseHandler.exceptionCaught(this.unwrap(clientResponse), throwable);
    }

    private <T> ClientResponse<RetryResponseHolder<T>> wrap(ClientResponse<T> response) {
        if (response.isFinished()) {
            return ClientResponse.finished(new RetryResponseHolder<Object>(false, response.getObj()));
        }
        return ClientResponse.unfinished(new RetryResponseHolder<Object>(false, response.getObj()), (boolean)response.isContinueReading());
    }

    private <T> ClientResponse<T> unwrap(ClientResponse<RetryResponseHolder<T>> response) {
        if (response.isFinished()) {
            return ClientResponse.finished(((RetryResponseHolder)response.getObj()).getObj());
        }
        return ClientResponse.unfinished(((RetryResponseHolder)response.getObj()).getObj(), (boolean)response.isContinueReading());
    }
}

