/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.amazonaws.services.sagemaker.model.DescribeImageRequest;
import com.amazonaws.services.sagemaker.model.DescribeImageVersionRequest;
import com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceRequest;
import com.amazonaws.services.sagemaker.model.DescribeProcessingJobRequest;
import com.amazonaws.services.sagemaker.model.DescribeTrainingJobRequest;
import com.amazonaws.services.sagemaker.model.DescribeTransformJobRequest;
import com.amazonaws.services.sagemaker.waiters.DescribeEndpointFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeImageFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeImageVersionFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeNotebookInstanceFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeProcessingJobFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeTrainingJobFunction;
import com.amazonaws.services.sagemaker.waiters.DescribeTransformJobFunction;
import com.amazonaws.services.sagemaker.waiters.EndpointDeleted;
import com.amazonaws.services.sagemaker.waiters.EndpointInService;
import com.amazonaws.services.sagemaker.waiters.ImageCreated;
import com.amazonaws.services.sagemaker.waiters.ImageDeleted;
import com.amazonaws.services.sagemaker.waiters.ImageUpdated;
import com.amazonaws.services.sagemaker.waiters.ImageVersionCreated;
import com.amazonaws.services.sagemaker.waiters.ImageVersionDeleted;
import com.amazonaws.services.sagemaker.waiters.NotebookInstanceDeleted;
import com.amazonaws.services.sagemaker.waiters.NotebookInstanceInService;
import com.amazonaws.services.sagemaker.waiters.NotebookInstanceStopped;
import com.amazonaws.services.sagemaker.waiters.ProcessingJobCompletedOrStopped;
import com.amazonaws.services.sagemaker.waiters.TrainingJobCompletedOrStopped;
import com.amazonaws.services.sagemaker.waiters.TransformJobCompletedOrStopped;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonSageMakerWaiters {
    private final AmazonSageMaker client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonSageMakerWaiters");

    @SdkInternalApi
    public AmazonSageMakerWaiters(AmazonSageMaker client) {
        this.client = client;
    }

    public Waiter<DescribeImageRequest> imageDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImageFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageDeleted.IsResourceNotFoundExceptionMatcher(), new ImageDeleted.IsDELETE_FAILEDMatcher(), new ImageDeleted.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NotebookInstanceStopped.IsStoppedMatcher(), new NotebookInstanceStopped.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NotebookInstanceInService.IsInServiceMatcher(), new NotebookInstanceInService.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTransformJobRequest> transformJobCompletedOrStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTransformJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TransformJobCompletedOrStopped.IsCompletedMatcher(), new TransformJobCompletedOrStopped.IsStoppedMatcher(), new TransformJobCompletedOrStopped.IsFailedMatcher(), new TransformJobCompletedOrStopped.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTrainingJobRequest> trainingJobCompletedOrStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTrainingJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TrainingJobCompletedOrStopped.IsCompletedMatcher(), new TrainingJobCompletedOrStopped.IsStoppedMatcher(), new TrainingJobCompletedOrStopped.IsFailedMatcher(), new TrainingJobCompletedOrStopped.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(180), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageRequest> imageCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImageFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageCreated.IsCREATEDMatcher(), new ImageCreated.IsCREATE_FAILEDMatcher(), new ImageCreated.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageVersionRequest> imageVersionDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImageVersionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageVersionDeleted.IsResourceNotFoundExceptionMatcher(), new ImageVersionDeleted.IsDELETE_FAILEDMatcher(), new ImageVersionDeleted.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NotebookInstanceDeleted.IsValidationExceptionMatcher(), new NotebookInstanceDeleted.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpointInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEndpointFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EndpointInService.IsInServiceMatcher(), new EndpointInService.IsFailedMatcher(), new EndpointInService.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpointDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEndpointFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EndpointDeleted.IsValidationExceptionMatcher(), new EndpointDeleted.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeProcessingJobRequest> processingJobCompletedOrStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeProcessingJobFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ProcessingJobCompletedOrStopped.IsCompletedMatcher(), new ProcessingJobCompletedOrStopped.IsStoppedMatcher(), new ProcessingJobCompletedOrStopped.IsFailedMatcher(), new ProcessingJobCompletedOrStopped.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageRequest> imageUpdated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImageFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageUpdated.IsCREATEDMatcher(), new ImageUpdated.IsUPDATE_FAILEDMatcher(), new ImageUpdated.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageVersionRequest> imageVersionCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImageVersionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageVersionCreated.IsCREATEDMatcher(), new ImageVersionCreated.IsCREATE_FAILEDMatcher(), new ImageVersionCreated.IsValidationExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

