/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.implementation.LoadBalancerBackendImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerProbe;
import com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.azure.resourcemanager.network.models.LoadDistribution;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.TransportProtocol;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Arrays;
import java.util.Collection;

class LoadBalancingRuleImpl
extends ChildResourceImpl<LoadBalancingRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancingRule,
LoadBalancingRule.Definition<LoadBalancer.DefinitionStages.WithLBRuleOrNatOrCreate>,
LoadBalancingRule.UpdateDefinition<LoadBalancer.Update>,
LoadBalancingRule.Update {
    LoadBalancingRuleImpl(LoadBalancingRuleInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((LoadBalancingRuleInner)((Object)this.innerModel())).name();
    }

    @Override
    public TransportProtocol protocol() {
        return ((LoadBalancingRuleInner)((Object)this.innerModel())).protocol();
    }

    @Override
    public boolean floatingIPEnabled() {
        return ((LoadBalancingRuleInner)((Object)this.innerModel())).enableFloatingIp();
    }

    @Override
    public int idleTimeoutInMinutes() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.innerModel())).idleTimeoutInMinutes());
    }

    @Override
    public int frontendPort() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.innerModel())).frontendPort());
    }

    @Override
    public int backendPort() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((LoadBalancingRuleInner)((Object)this.innerModel())).backendPort());
    }

    @Override
    public LoadDistribution loadDistribution() {
        return ((LoadBalancingRuleInner)((Object)this.innerModel())).loadDistribution();
    }

    @Override
    public LoadBalancerFrontend frontend() {
        SubResource frontendRef = ((LoadBalancingRuleInner)((Object)this.innerModel())).frontendIpConfiguration();
        if (frontendRef == null) {
            return null;
        }
        String frontendName = ResourceUtils.nameFromResourceId((String)frontendRef.id());
        return ((LoadBalancerImpl)this.parent()).frontends().get(frontendName);
    }

    @Override
    public LoadBalancerBackend backend() {
        SubResource backendRef = ((LoadBalancingRuleInner)((Object)this.innerModel())).backendAddressPool();
        if (backendRef == null) {
            return null;
        }
        String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
        return ((LoadBalancerImpl)this.parent()).backends().get(backendName);
    }

    @Override
    public LoadBalancerProbe probe() {
        SubResource probeRef = ((LoadBalancingRuleInner)((Object)this.innerModel())).probe();
        if (probeRef == null) {
            return null;
        }
        String probeName = ResourceUtils.nameFromResourceId((String)probeRef.id());
        if (((LoadBalancerImpl)this.parent()).httpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).httpProbes().get(probeName);
        }
        if (((LoadBalancerImpl)this.parent()).tcpProbes().containsKey(probeName)) {
            return ((LoadBalancerImpl)this.parent()).tcpProbes().get(probeName);
        }
        return null;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingPublicIPAddress(PublicIpAddress publicIPAddress) {
        return publicIPAddress != null ? this.fromExistingPublicIPAddress(publicIPAddress.id()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingPublicIPAddress(String resourceId) {
        return null != resourceId ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePublicFrontendWithPip(resourceId).name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress(String leafDnsLabel) {
        String frontendName = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress(Creatable<PublicIpAddress> pipDefinition) {
        String frontendName = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(pipDefinition, frontendName);
        return this.fromFrontend(frontendName);
    }

    @Override
    public LoadBalancingRuleImpl fromNewPublicIPAddress() {
        String dnsLabel = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        return this.fromNewPublicIPAddress(dnsLabel);
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(String networkResourceId, String subnetName) {
        return null != networkResourceId && null != subnetName ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePrivateFrontendWithSubnet(networkResourceId, subnetName).name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(Network network, String subnetName) {
        return null != network && null != subnetName ? this.fromExistingSubnet(network.id(), subnetName) : this;
    }

    @Override
    public LoadBalancingRuleImpl fromExistingSubnet(Subnet subnet) {
        return null != subnet ? this.fromExistingSubnet(((Network)subnet.parent()).id(), subnet.name()) : this;
    }

    @Override
    public LoadBalancingRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIP(boolean enable) {
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withEnableFloatingIp(enable);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIPEnabled() {
        return this.withFloatingIP(true);
    }

    @Override
    public LoadBalancingRuleImpl withFloatingIPDisabled() {
        return this.withFloatingIP(false);
    }

    @Override
    public LoadBalancingRuleImpl withProtocol(TransportProtocol protocol) {
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withProtocol(protocol);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl fromFrontendPort(int port) {
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withFrontendPort(port);
        if (((LoadBalancingRuleInner)((Object)this.innerModel())).backendPort() == null || ((LoadBalancingRuleInner)((Object)this.innerModel())).backendPort() == 0) {
            ((LoadBalancingRuleInner)((Object)this.innerModel())).withBackendPort(port);
        }
        return this;
    }

    @Override
    public LoadBalancingRuleImpl toBackendPort(int port) {
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withBackendPort(port);
        return this;
    }

    public LoadBalancingRuleImpl toExistingVirtualMachines(HasNetworkInterfaces ... vms) {
        return vms != null ? this.toExistingVirtualMachines(Arrays.asList(vms)) : this;
    }

    public LoadBalancingRuleImpl toExistingVirtualMachines(Collection<HasNetworkInterfaces> vms) {
        if (vms != null) {
            LoadBalancerBackend.DefinitionStages.WithAttach backend = ((LoadBalancerImpl)this.parent()).ensureUniqueBackend().withExistingVirtualMachines((Collection)vms);
            this.toBackend(((LoadBalancerBackendImpl)backend).name());
        }
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withLoadDistribution(LoadDistribution loadDistribution) {
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withLoadDistribution(loadDistribution);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl fromFrontend(String frontendName) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(frontendName);
        if (frontendRef != null) {
            ((LoadBalancingRuleInner)((Object)this.innerModel())).withFrontendIpConfiguration(frontendRef);
        }
        return this;
    }

    public LoadBalancingRuleImpl toBackend(String backendName) {
        ((LoadBalancerImpl)this.parent()).defineBackend(backendName).attach();
        SubResource backendRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/backendAddressPools/" + backendName);
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withBackendAddressPool(backendRef);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withProbe(String name) {
        SubResource probeRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/probes/" + name);
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withProbe(probeRef);
        return this;
    }

    @Override
    public LoadBalancingRuleImpl withoutProbe() {
        ((LoadBalancingRuleInner)((Object)this.innerModel())).withProbe(null);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withLoadBalancingRule(this);
    }
}

