/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.fluent.models.NetworkProfilePropertiesFormat;
import com.azure.resourcemanager.network.models.ContainerNetworkInterface;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class NetworkProfileInner
extends Resource {
    @JsonProperty(value="properties")
    private NetworkProfilePropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private NetworkProfilePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NetworkProfileInner withId(String id) {
        this.id = id;
        return this;
    }

    public NetworkProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<ContainerNetworkInterface> containerNetworkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaces();
    }

    public List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaceConfigurations();
    }

    public NetworkProfileInner withContainerNetworkInterfaceConfigurations(List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkProfilePropertiesFormat();
        }
        this.innerProperties().withContainerNetworkInterfaceConfigurations(containerNetworkInterfaceConfigurations);
        return this;
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

