/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.WebActivityAuthentication;
import com.azure.resourcemanager.datafactory.models.WebActivityMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WebActivityTypeProperties {
    @JsonProperty(value="method", required=true)
    private WebActivityMethod method;
    @JsonProperty(value="url", required=true)
    private Object url;
    @JsonProperty(value="headers")
    private Object headers;
    @JsonProperty(value="body")
    private Object body;
    @JsonProperty(value="authentication")
    private WebActivityAuthentication authentication;
    @JsonProperty(value="disableCertValidation")
    private Boolean disableCertValidation;
    @JsonProperty(value="datasets")
    private List<DatasetReference> datasets;
    @JsonProperty(value="linkedServices")
    private List<LinkedServiceReference> linkedServices;
    @JsonProperty(value="connectVia")
    private IntegrationRuntimeReference connectVia;
    private static final ClientLogger LOGGER = new ClientLogger(WebActivityTypeProperties.class);

    public WebActivityMethod method() {
        return this.method;
    }

    public WebActivityTypeProperties withMethod(WebActivityMethod method) {
        this.method = method;
        return this;
    }

    public Object url() {
        return this.url;
    }

    public WebActivityTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object headers() {
        return this.headers;
    }

    public WebActivityTypeProperties withHeaders(Object headers) {
        this.headers = headers;
        return this;
    }

    public Object body() {
        return this.body;
    }

    public WebActivityTypeProperties withBody(Object body) {
        this.body = body;
        return this;
    }

    public WebActivityAuthentication authentication() {
        return this.authentication;
    }

    public WebActivityTypeProperties withAuthentication(WebActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public Boolean disableCertValidation() {
        return this.disableCertValidation;
    }

    public WebActivityTypeProperties withDisableCertValidation(Boolean disableCertValidation) {
        this.disableCertValidation = disableCertValidation;
        return this;
    }

    public List<DatasetReference> datasets() {
        return this.datasets;
    }

    public WebActivityTypeProperties withDatasets(List<DatasetReference> datasets) {
        this.datasets = datasets;
        return this;
    }

    public List<LinkedServiceReference> linkedServices() {
        return this.linkedServices;
    }

    public WebActivityTypeProperties withLinkedServices(List<LinkedServiceReference> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.connectVia;
    }

    public WebActivityTypeProperties withConnectVia(IntegrationRuntimeReference connectVia) {
        this.connectVia = connectVia;
        return this;
    }

    public void validate() {
        if (this.method() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property method in model WebActivityTypeProperties"));
        }
        if (this.url() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property url in model WebActivityTypeProperties"));
        }
        if (this.authentication() != null) {
            this.authentication().validate();
        }
        if (this.datasets() != null) {
            this.datasets().forEach(e -> e.validate());
        }
        if (this.linkedServices() != null) {
            this.linkedServices().forEach(e -> e.validate());
        }
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
    }
}

