/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowBackFillRequest;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.common.utils.JSONUtils;

public class WorkflowUtils {
    public static List<Long> parseStartNodeList(String startNodes) {
        try {
            if (StringUtils.isEmpty((CharSequence)startNodes)) {
                return new ArrayList<Long>();
            }
            return Arrays.stream(startNodes.split(",")).map(String::trim).map(Long::parseLong).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new ServiceException("Parse startNodes: " + startNodes + " error", ex);
        }
    }

    public static WorkflowBackFillRequest.BackfillTime parseBackfillTime(String backfillTimeJson) {
        try {
            if (StringUtils.isEmpty((CharSequence)backfillTimeJson)) {
                throw new IllegalArgumentException("backfillTime is empty");
            }
            WorkflowBackFillRequest.BackfillTime backfillTime = (WorkflowBackFillRequest.BackfillTime)JSONUtils.parseObject((String)backfillTimeJson, WorkflowBackFillRequest.BackfillTime.class);
            if (backfillTime == null) {
                throw new IllegalArgumentException("backfillTime is invalid");
            }
            return backfillTime;
        }
        catch (Exception ex) {
            throw new ServiceException("Parse backfillTime: " + backfillTimeJson + " error", ex);
        }
    }
}

