/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.repository;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.mapper.JdbcRegistryLockMapper;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DO.JdbcRegistryLock;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryLockDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JdbcRegistryLockRepository {
    @Autowired
    private JdbcRegistryLockMapper jdbcRegistryLockMapper;

    public List<JdbcRegistryLockDTO> queryAll() {
        return this.jdbcRegistryLockMapper.selectList(null).stream().map(JdbcRegistryLockDTO::fromJdbcRegistryLock).collect(Collectors.toList());
    }

    public void deleteByClientIds(List<Long> clientIds) {
        if (CollectionUtils.isEmpty(clientIds)) {
            return;
        }
        this.jdbcRegistryLockMapper.deleteByClientIds(clientIds);
    }

    public void insert(JdbcRegistryLockDTO jdbcRegistryLock) {
        Preconditions.checkNotNull((Object)jdbcRegistryLock);
        JdbcRegistryLock jdbcRegistryLockDO = JdbcRegistryLockDTO.toJdbcRegistryLock(jdbcRegistryLock);
        this.jdbcRegistryLockMapper.insert(jdbcRegistryLockDO);
        jdbcRegistryLock.setId(jdbcRegistryLockDO.getId());
    }

    public void deleteById(Long id) {
        this.jdbcRegistryLockMapper.deleteById(id);
    }
}

