/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetInner;
import com.azure.resourcemanager.compute.implementation.DiskEncryptionSetMsiHandler;
import com.azure.resourcemanager.compute.models.DiskEncryptionSet;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetIdentityType;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetUpdate;
import com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.azure.resourcemanager.compute.models.SourceVault;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import reactor.core.publisher.Mono;

public class DiskEncryptionSetImpl
extends GroupableResourceImpl<DiskEncryptionSet, DiskEncryptionSetInner, DiskEncryptionSetImpl, ComputeManager>
implements DiskEncryptionSet,
DiskEncryptionSet.Definition,
DiskEncryptionSet.Update {
    private DiskEncryptionSetUpdate patchToUpdate = new DiskEncryptionSetUpdate();
    private boolean updated;
    private final DiskEncryptionSetMsiHandler msiHandler;

    protected DiskEncryptionSetImpl(String name, DiskEncryptionSetInner innerObject, ComputeManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
        this.msiHandler = new DiskEncryptionSetMsiHandler(manager.authorizationManager(), this);
    }

    @Override
    public String keyVaultId() {
        if (((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey() == null || ((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey().sourceVault() == null) {
            return null;
        }
        return ((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey().sourceVault().id();
    }

    @Override
    public String encryptionKeyId() {
        if (((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey() == null) {
            return null;
        }
        return ((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey().keyUrl();
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((DiskEncryptionSetInner)((Object)this.innerModel())).identity() == null || ((DiskEncryptionSetInner)((Object)this.innerModel())).identity().type() == DiskEncryptionSetIdentityType.NONE) {
            return null;
        }
        return ((DiskEncryptionSetInner)((Object)this.innerModel())).identity().principalId();
    }

    @Override
    public Boolean isAutomaticKeyRotationEnabled() {
        return ((DiskEncryptionSetInner)((Object)this.innerModel())).rotationToLatestKeyVersionEnabled();
    }

    @Override
    public DiskEncryptionSetType encryptionType() {
        return ((DiskEncryptionSetInner)((Object)this.innerModel())).encryptionType();
    }

    @Override
    public DiskEncryptionSetImpl withAutomaticKeyRotation() {
        ((DiskEncryptionSetInner)((Object)this.innerModel())).withRotationToLatestKeyVersionEnabled(true);
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withRotationToLatestKeyVersionEnabled(true);
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withoutAutomaticKeyRotation() {
        ((DiskEncryptionSetInner)((Object)this.innerModel())).withRotationToLatestKeyVersionEnabled(false);
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withRotationToLatestKeyVersionEnabled(false);
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withSystemAssignedManagedServiceIdentity() {
        ((DiskEncryptionSetInner)((Object)this.innerModel())).withIdentity(new EncryptionSetIdentity().withType(DiskEncryptionSetIdentityType.SYSTEM_ASSIGNED));
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withIdentity(((DiskEncryptionSetInner)((Object)this.innerModel())).identity());
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withoutSystemAssignedManagedServiceIdentity() {
        ((DiskEncryptionSetInner)((Object)this.innerModel())).withIdentity(new EncryptionSetIdentity().withType(DiskEncryptionSetIdentityType.NONE));
        if (this.isInUpdateMode()) {
            this.patchToUpdate.withIdentity(((DiskEncryptionSetInner)((Object)this.innerModel())).identity());
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withExistingKeyVault(String keyVaultId) {
        this.ensureActiveKey();
        ((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey().withSourceVault(new SourceVault().withId(keyVaultId));
        if (this.isInUpdateMode()) {
            this.ensureActiveKey(this.patchToUpdate);
            this.patchToUpdate.activeKey().withSourceVault(((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey().sourceVault());
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withRoleBasedAccessToCurrentKeyVault(BuiltInRole builtInRole) {
        if (this.keyVaultId() != null) {
            this.msiHandler.withAccessTo(this.keyVaultId(), builtInRole);
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withRoleBasedAccessToCurrentKeyVault() {
        return this.withRoleBasedAccessToCurrentKeyVault(BuiltInRole.KEY_VAULT_CRYPTO_SERVICE_ENCRYPTION_USER);
    }

    public Mono<DiskEncryptionSet> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDiskEncryptionSets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (DiskEncryptionSetInner)((Object)this.innerModel())).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public DiskEncryptionSetImpl update() {
        this.patchToUpdate = new DiskEncryptionSetUpdate();
        return this;
    }

    public Mono<DiskEncryptionSet> updateResourceAsync() {
        if (!this.updated) {
            return Mono.just((Object)this);
        }
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDiskEncryptionSets().updateAsync(this.resourceGroupName(), this.name(), this.patchToUpdate).map(inner -> {
            this.setInner(inner);
            this.updated = false;
            return this;
        });
    }

    protected Mono<DiskEncryptionSetInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDiskEncryptionSets().getByResourceGroupAsync(this.resourceGroupName(), this.name()).map(inner -> {
            this.updated = false;
            return inner;
        });
    }

    @Override
    public DiskEncryptionSetImpl withExistingKey(String keyId) {
        this.ensureActiveKey();
        ((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey().withKeyUrl(keyId);
        if (this.isInUpdateMode()) {
            this.ensureActiveKey(this.patchToUpdate);
            this.patchToUpdate.activeKey().withKeyUrl(keyId);
            this.updated = true;
        }
        return this;
    }

    @Override
    public DiskEncryptionSetImpl withEncryptionType(DiskEncryptionSetType type) {
        ((DiskEncryptionSetInner)((Object)this.innerModel())).withEncryptionType(type);
        return this;
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                return DiskEncryptionSetImpl.this.systemAssignedManagedServiceIdentityPrincipalId();
            }

            public String resourceId() {
                return DiskEncryptionSetImpl.this.id();
            }
        };
    }

    private void ensureActiveKey() {
        if (((DiskEncryptionSetInner)((Object)this.innerModel())).activeKey() == null) {
            ((DiskEncryptionSetInner)((Object)this.innerModel())).withActiveKey(new KeyForDiskEncryptionSet());
        }
    }

    private void ensureActiveKey(DiskEncryptionSetUpdate patchToUpdate) {
        if (patchToUpdate.activeKey() == null) {
            patchToUpdate.withActiveKey(new KeyForDiskEncryptionSet());
        }
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }
}

