/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType;
import software.amazon.awssdk.services.datasync.model.HdfsNameNode;
import software.amazon.awssdk.services.datasync.model.HdfsNameNodeListCopier;
import software.amazon.awssdk.services.datasync.model.QopConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationHdfsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationHdfsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::locationArn)).setter(DescribeLocationHdfsResponse.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::locationUri)).setter(DescribeLocationHdfsResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<List<HdfsNameNode>> NAME_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NameNodes").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::nameNodes)).setter(DescribeLocationHdfsResponse.setter(Builder::nameNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HdfsNameNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> BLOCK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockSize").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::blockSize)).setter(DescribeLocationHdfsResponse.setter(Builder::blockSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSize").build()}).build();
    private static final SdkField<Integer> REPLICATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplicationFactor").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::replicationFactor)).setter(DescribeLocationHdfsResponse.setter(Builder::replicationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationFactor").build()}).build();
    private static final SdkField<String> KMS_KEY_PROVIDER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyProviderUri").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::kmsKeyProviderUri)).setter(DescribeLocationHdfsResponse.setter(Builder::kmsKeyProviderUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyProviderUri").build()}).build();
    private static final SdkField<QopConfiguration> QOP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QopConfiguration").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::qopConfiguration)).setter(DescribeLocationHdfsResponse.setter(Builder::qopConfiguration)).constructor(QopConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QopConfiguration").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::authenticationTypeAsString)).setter(DescribeLocationHdfsResponse.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<String> SIMPLE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SimpleUser").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::simpleUser)).setter(DescribeLocationHdfsResponse.setter(Builder::simpleUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleUser").build()}).build();
    private static final SdkField<String> KERBEROS_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KerberosPrincipal").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::kerberosPrincipal)).setter(DescribeLocationHdfsResponse.setter(Builder::kerberosPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KerberosPrincipal").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::agentArns)).setter(DescribeLocationHdfsResponse.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeLocationHdfsResponse.getter(DescribeLocationHdfsResponse::creationTime)).setter(DescribeLocationHdfsResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, NAME_NODES_FIELD, BLOCK_SIZE_FIELD, REPLICATION_FACTOR_FIELD, KMS_KEY_PROVIDER_URI_FIELD, QOP_CONFIGURATION_FIELD, AUTHENTICATION_TYPE_FIELD, SIMPLE_USER_FIELD, KERBEROS_PRINCIPAL_FIELD, AGENT_ARNS_FIELD, CREATION_TIME_FIELD));
    private final String locationArn;
    private final String locationUri;
    private final List<HdfsNameNode> nameNodes;
    private final Integer blockSize;
    private final Integer replicationFactor;
    private final String kmsKeyProviderUri;
    private final QopConfiguration qopConfiguration;
    private final String authenticationType;
    private final String simpleUser;
    private final String kerberosPrincipal;
    private final List<String> agentArns;
    private final Instant creationTime;

    private DescribeLocationHdfsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.nameNodes = builder.nameNodes;
        this.blockSize = builder.blockSize;
        this.replicationFactor = builder.replicationFactor;
        this.kmsKeyProviderUri = builder.kmsKeyProviderUri;
        this.qopConfiguration = builder.qopConfiguration;
        this.authenticationType = builder.authenticationType;
        this.simpleUser = builder.simpleUser;
        this.kerberosPrincipal = builder.kerberosPrincipal;
        this.agentArns = builder.agentArns;
        this.creationTime = builder.creationTime;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final boolean hasNameNodes() {
        return this.nameNodes != null && !(this.nameNodes instanceof SdkAutoConstructList);
    }

    public final List<HdfsNameNode> nameNodes() {
        return this.nameNodes;
    }

    public final Integer blockSize() {
        return this.blockSize;
    }

    public final Integer replicationFactor() {
        return this.replicationFactor;
    }

    public final String kmsKeyProviderUri() {
        return this.kmsKeyProviderUri;
    }

    public final QopConfiguration qopConfiguration() {
        return this.qopConfiguration;
    }

    public final HdfsAuthenticationType authenticationType() {
        return HdfsAuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final String simpleUser() {
        return this.simpleUser;
    }

    public final String kerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameNodes() ? this.nameNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.blockSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyProviderUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.qopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.simpleUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.kerberosPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationHdfsResponse)) {
            return false;
        }
        DescribeLocationHdfsResponse other = (DescribeLocationHdfsResponse)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && this.hasNameNodes() == other.hasNameNodes() && Objects.equals(this.nameNodes(), other.nameNodes()) && Objects.equals(this.blockSize(), other.blockSize()) && Objects.equals(this.replicationFactor(), other.replicationFactor()) && Objects.equals(this.kmsKeyProviderUri(), other.kmsKeyProviderUri()) && Objects.equals(this.qopConfiguration(), other.qopConfiguration()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.simpleUser(), other.simpleUser()) && Objects.equals(this.kerberosPrincipal(), other.kerberosPrincipal()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocationHdfsResponse").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("NameNodes", this.hasNameNodes() ? this.nameNodes() : null).add("BlockSize", (Object)this.blockSize()).add("ReplicationFactor", (Object)this.replicationFactor()).add("KmsKeyProviderUri", (Object)this.kmsKeyProviderUri()).add("QopConfiguration", (Object)this.qopConfiguration()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("SimpleUser", (Object)this.simpleUser()).add("KerberosPrincipal", (Object)this.kerberosPrincipal()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "NameNodes": {
                return Optional.ofNullable(clazz.cast(this.nameNodes()));
            }
            case "BlockSize": {
                return Optional.ofNullable(clazz.cast(this.blockSize()));
            }
            case "ReplicationFactor": {
                return Optional.ofNullable(clazz.cast(this.replicationFactor()));
            }
            case "KmsKeyProviderUri": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyProviderUri()));
            }
            case "QopConfiguration": {
                return Optional.ofNullable(clazz.cast(this.qopConfiguration()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "SimpleUser": {
                return Optional.ofNullable(clazz.cast(this.simpleUser()));
            }
            case "KerberosPrincipal": {
                return Optional.ofNullable(clazz.cast(this.kerberosPrincipal()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationHdfsResponse, T> g) {
        return obj -> g.apply((DescribeLocationHdfsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private List<HdfsNameNode> nameNodes = DefaultSdkAutoConstructList.getInstance();
        private Integer blockSize;
        private Integer replicationFactor;
        private String kmsKeyProviderUri;
        private QopConfiguration qopConfiguration;
        private String authenticationType;
        private String simpleUser;
        private String kerberosPrincipal;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationHdfsResponse model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.nameNodes(model.nameNodes);
            this.blockSize(model.blockSize);
            this.replicationFactor(model.replicationFactor);
            this.kmsKeyProviderUri(model.kmsKeyProviderUri);
            this.qopConfiguration(model.qopConfiguration);
            this.authenticationType(model.authenticationType);
            this.simpleUser(model.simpleUser);
            this.kerberosPrincipal(model.kerberosPrincipal);
            this.agentArns(model.agentArns);
            this.creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final List<HdfsNameNode.Builder> getNameNodes() {
            List<HdfsNameNode.Builder> result = HdfsNameNodeListCopier.copyToBuilder(this.nameNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNameNodes(Collection<HdfsNameNode.BuilderImpl> nameNodes) {
            this.nameNodes = HdfsNameNodeListCopier.copyFromBuilder(nameNodes);
        }

        @Override
        public final Builder nameNodes(Collection<HdfsNameNode> nameNodes) {
            this.nameNodes = HdfsNameNodeListCopier.copy(nameNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameNodes(HdfsNameNode ... nameNodes) {
            this.nameNodes(Arrays.asList(nameNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameNodes(Consumer<HdfsNameNode.Builder> ... nameNodes) {
            this.nameNodes(Stream.of(nameNodes).map(c -> (HdfsNameNode)((HdfsNameNode.Builder)HdfsNameNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getBlockSize() {
            return this.blockSize;
        }

        public final void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        @Override
        public final Builder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public final Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public final void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        public final Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public final String getKmsKeyProviderUri() {
            return this.kmsKeyProviderUri;
        }

        public final void setKmsKeyProviderUri(String kmsKeyProviderUri) {
            this.kmsKeyProviderUri = kmsKeyProviderUri;
        }

        @Override
        public final Builder kmsKeyProviderUri(String kmsKeyProviderUri) {
            this.kmsKeyProviderUri = kmsKeyProviderUri;
            return this;
        }

        public final QopConfiguration.Builder getQopConfiguration() {
            return this.qopConfiguration != null ? this.qopConfiguration.toBuilder() : null;
        }

        public final void setQopConfiguration(QopConfiguration.BuilderImpl qopConfiguration) {
            this.qopConfiguration = qopConfiguration != null ? qopConfiguration.build() : null;
        }

        @Override
        public final Builder qopConfiguration(QopConfiguration qopConfiguration) {
            this.qopConfiguration = qopConfiguration;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(HdfsAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getSimpleUser() {
            return this.simpleUser;
        }

        public final void setSimpleUser(String simpleUser) {
            this.simpleUser = simpleUser;
        }

        @Override
        public final Builder simpleUser(String simpleUser) {
            this.simpleUser = simpleUser;
            return this;
        }

        public final String getKerberosPrincipal() {
            return this.kerberosPrincipal;
        }

        public final void setKerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
        }

        @Override
        public final Builder kerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationHdfsResponse build() {
            return new DescribeLocationHdfsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationHdfsResponse> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder nameNodes(Collection<HdfsNameNode> var1);

        public Builder nameNodes(HdfsNameNode ... var1);

        public Builder nameNodes(Consumer<HdfsNameNode.Builder> ... var1);

        public Builder blockSize(Integer var1);

        public Builder replicationFactor(Integer var1);

        public Builder kmsKeyProviderUri(String var1);

        public Builder qopConfiguration(QopConfiguration var1);

        default public Builder qopConfiguration(Consumer<QopConfiguration.Builder> qopConfiguration) {
            return this.qopConfiguration((QopConfiguration)((QopConfiguration.Builder)QopConfiguration.builder().applyMutation(qopConfiguration)).build());
        }

        public Builder authenticationType(String var1);

        public Builder authenticationType(HdfsAuthenticationType var1);

        public Builder simpleUser(String var1);

        public Builder kerberosPrincipal(String var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder creationTime(Instant var1);
    }
}

