/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.server;

import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.RpcMethod;
import org.apache.dolphinscheduler.extract.base.RpcService;
import org.apache.dolphinscheduler.extract.base.config.NettyServerConfig;
import org.apache.dolphinscheduler.extract.base.server.NettyRemotingServer;
import org.apache.dolphinscheduler.extract.base.server.NettyRemotingServerFactory;
import org.apache.dolphinscheduler.extract.base.server.ServerMethodInvokerImpl;
import org.apache.dolphinscheduler.extract.base.server.ServerMethodInvokerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer
implements ServerMethodInvokerRegistry,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RpcServer.class);
    private final NettyRemotingServer nettyRemotingServer;

    public RpcServer(NettyServerConfig nettyServerConfig) {
        this.nettyRemotingServer = NettyRemotingServerFactory.buildNettyRemotingServer(nettyServerConfig);
    }

    public void start() {
        this.nettyRemotingServer.start();
    }

    @Override
    public void registerServerMethodInvokerProvider(Object serverMethodInvokerProviderBean) {
        for (Class<?> anInterface : serverMethodInvokerProviderBean.getClass().getInterfaces()) {
            if (anInterface.getAnnotation(RpcService.class) == null) continue;
            for (Method method : anInterface.getDeclaredMethods()) {
                RpcMethod rpcMethod = method.getAnnotation(RpcMethod.class);
                if (rpcMethod == null) continue;
                ServerMethodInvokerImpl serverMethodInvoker = new ServerMethodInvokerImpl(serverMethodInvokerProviderBean, method);
                this.nettyRemotingServer.registerMethodInvoker(serverMethodInvoker);
                log.debug("Register ServerMethodInvoker: {} to bean: {}", (Object)serverMethodInvoker.getMethodIdentify(), (Object)serverMethodInvoker.getMethodProviderIdentify());
            }
        }
    }

    @Override
    public void close() {
        this.nettyRemotingServer.close();
    }
}

