/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.FileSourceMarshaller;
import java.io.Serializable;

public class FileSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String contentType;
    private String contentDigest;
    private String s3Uri;

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public FileSource withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public void setContentDigest(String contentDigest) {
        this.contentDigest = contentDigest;
    }

    public String getContentDigest() {
        return this.contentDigest;
    }

    public FileSource withContentDigest(String contentDigest) {
        this.setContentDigest(contentDigest);
        return this;
    }

    public void setS3Uri(String s3Uri) {
        this.s3Uri = s3Uri;
    }

    public String getS3Uri() {
        return this.s3Uri;
    }

    public FileSource withS3Uri(String s3Uri) {
        this.setS3Uri(s3Uri);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getContentDigest() != null) {
            sb.append("ContentDigest: ").append(this.getContentDigest()).append(",");
        }
        if (this.getS3Uri() != null) {
            sb.append("S3Uri: ").append(this.getS3Uri());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSource)) {
            return false;
        }
        FileSource other = (FileSource)obj;
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getContentDigest() == null ^ this.getContentDigest() == null) {
            return false;
        }
        if (other.getContentDigest() != null && !other.getContentDigest().equals(this.getContentDigest())) {
            return false;
        }
        if (other.getS3Uri() == null ^ this.getS3Uri() == null) {
            return false;
        }
        return other.getS3Uri() == null || other.getS3Uri().equals(this.getS3Uri());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getContentDigest() == null ? 0 : this.getContentDigest().hashCode());
        hashCode = 31 * hashCode + (this.getS3Uri() == null ? 0 : this.getS3Uri().hashCode());
        return hashCode;
    }

    public FileSource clone() {
        try {
            return (FileSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

