/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Function;

public class VerboseResult<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long operationTimeNanos;
    private final T value;
    private final BucketConfiguration configuration;
    private final BucketState state;
    public static final SerializationHandle<VerboseResult<?>> SERIALIZATION_HANDLE = new SerializationHandle<VerboseResult<?>>(){

        @Override
        public <I> VerboseResult<?> deserialize(DeserializationAdapter<I> adapter, I input) throws IOException {
            long operationTimeNanos = adapter.readLong(input);
            Serializable result = (Serializable)adapter.readObject(input);
            BucketConfiguration configuration = adapter.readObject(input, BucketConfiguration.class);
            BucketState state = adapter.readObject(input, BucketState.class);
            return new VerboseResult<Serializable>(operationTimeNanos, result, configuration, state);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, VerboseResult<?> result) throws IOException {
            adapter.writeLong(output, ((VerboseResult)result).operationTimeNanos);
            adapter.writeObject(output, ((VerboseResult)result).value);
            adapter.writeObject(output, ((VerboseResult)result).configuration);
            adapter.writeObject(output, ((VerboseResult)result).state);
        }

        @Override
        public int getTypeId() {
            return 24;
        }

        @Override
        public Class<VerboseResult<?>> getSerializedType() {
            return VerboseResult.class;
        }
    };

    public VerboseResult(long operationTimeNanos, T value, BucketConfiguration configuration, BucketState state) {
        this.operationTimeNanos = operationTimeNanos;
        this.value = value;
        this.configuration = configuration;
        this.state = state;
    }

    public T getValue() {
        return this.value;
    }

    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    public BucketState getState() {
        return this.state;
    }

    public long getOperationTimeNanos() {
        return this.operationTimeNanos;
    }

    public <R extends Serializable> VerboseResult<R> map(Function<T, R> mapper) {
        return new VerboseResult<Serializable>(this.operationTimeNanos, (Serializable)mapper.apply(this.value), this.configuration, this.state);
    }
}

