/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.models.NsRecord;
import com.azure.resourcemanager.dns.models.NsRecordSet;
import com.azure.resourcemanager.dns.models.RecordType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class NsRecordSetImpl
extends DnsRecordSetImpl
implements NsRecordSet {
    NsRecordSetImpl(String name, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.NS.toString(), parent, innerModel);
    }

    static NsRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new NsRecordSetImpl(name, parent, new RecordSetInner().withNsRecords(new ArrayList<NsRecord>()));
    }

    @Override
    public List<String> nameServers() {
        ArrayList<String> nameServers = new ArrayList<String>();
        if (((RecordSetInner)((Object)this.innerModel())).nsRecords() != null) {
            for (NsRecord nsRecord : ((RecordSetInner)((Object)this.innerModel())).nsRecords()) {
                nameServers.add(nsRecord.nsdname());
            }
        }
        return Collections.unmodifiableList(nameServers);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)((Object)this.innerModel())).nsRecords() != null && ((RecordSetInner)((Object)this.innerModel())).nsRecords().size() > 0) {
            if (resource.nsRecords() == null) {
                resource.withNsRecords(new ArrayList<NsRecord>());
            }
            for (NsRecord record : ((RecordSetInner)((Object)this.innerModel())).nsRecords()) {
                resource.nsRecords().add(record);
            }
            ((RecordSetInner)((Object)this.innerModel())).nsRecords().clear();
        }
        if (this.recordSetRemoveInfo.nsRecords().size() > 0) {
            if (resource.nsRecords() != null) {
                block1: for (NsRecord recordToRemove : this.recordSetRemoveInfo.nsRecords()) {
                    for (NsRecord record : resource.nsRecords()) {
                        if (!record.nsdname().equalsIgnoreCase(recordToRemove.nsdname())) continue;
                        resource.nsRecords().remove(record);
                        continue block1;
                    }
                }
            }
            this.recordSetRemoveInfo.nsRecords().clear();
        }
        return resource;
    }
}

