/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.dependent;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.common.enums.ContextType;
import org.apache.dolphinscheduler.dao.entity.AbstractTaskInstanceContext;
import org.apache.dolphinscheduler.dao.entity.DependentResultTaskInstanceContext;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstanceContext;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.ProjectDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceContextDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentRelation;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentItem;
import org.apache.dolphinscheduler.plugin.task.api.model.DependentTaskModel;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.DependentParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.DependentUtils;
import org.apache.dolphinscheduler.server.master.utils.DependentExecute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentTaskTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DependentTaskTracker.class);
    private final TaskExecutionContext taskExecutionContext;
    private final DependentParameters dependentParameters;
    private final ProjectDao projectDao;
    private final WorkflowDefinitionDao workflowDefinitionDao;
    private final TaskDefinitionDao taskDefinitionDao;
    private final TaskInstanceDao taskInstanceDao;
    private final TaskInstanceContextDao taskInstanceContextDao;
    private final WorkflowInstance workflowInstance;
    private final Date dependentDate;
    private final List<DependentExecute> dependentTaskList;
    private final Map<String, DependResult> dependResultMap;
    private final Map<String, Property> dependVarPoolPropertyMap;
    private Map<Long, WorkflowDefinition> processDefinitionMap;
    private Map<Long, TaskDefinition> taskDefinitionMap;
    private Map<Long, Project> projectCodeMap;
    private TaskInstanceContext taskInstanceContext;

    public DependentTaskTracker(TaskExecutionContext taskExecutionContext, DependentParameters dependentParameters, ProjectDao projectDao, WorkflowDefinitionDao workflowDefinitionDao, TaskDefinitionDao taskDefinitionDao, TaskInstanceDao taskInstanceDao, WorkflowInstanceDao workflowInstanceDao, TaskInstanceContextDao taskInstanceContextDao) {
        this.taskExecutionContext = taskExecutionContext;
        this.dependentParameters = dependentParameters;
        this.projectDao = projectDao;
        this.workflowDefinitionDao = workflowDefinitionDao;
        this.taskDefinitionDao = taskDefinitionDao;
        this.taskInstanceDao = taskInstanceDao;
        this.taskInstanceContextDao = taskInstanceContextDao;
        this.workflowInstance = (WorkflowInstance)workflowInstanceDao.queryById((Serializable)Integer.valueOf(taskExecutionContext.getWorkflowInstanceId()));
        this.dependentDate = this.calculateDependentDate();
        this.dependentTaskList = this.initializeDependentTaskList();
        this.dependResultMap = new HashMap<String, DependResult>();
        this.dependVarPoolPropertyMap = new HashMap<String, Property>();
        this.taskInstanceContext = new TaskInstanceContext();
        this.initTaskDependentResult();
    }

    @NonNull
    public TaskExecutionStatus getDependentTaskStatus() {
        if (this.isAllDependentTaskFinished()) {
            log.info("All dependent task finished, will calculate the dependent result");
            DependResult dependResult = this.calculateDependResult();
            log.info("The final Dependent result is: {}", (Object)dependResult);
            if (dependResult == DependResult.SUCCESS) {
                this.dependentParameters.setVarPool(new ArrayList<Property>(this.dependVarPoolPropertyMap.values()));
                log.info("Set dependentParameters varPool: {}", (Object)this.dependentParameters.getVarPool());
                return TaskExecutionStatus.SUCCESS;
            }
            return TaskExecutionStatus.FAILURE;
        }
        return TaskExecutionStatus.RUNNING_EXECUTION;
    }

    private Date calculateDependentDate() {
        if (this.workflowInstance.getScheduleTime() != null) {
            return this.workflowInstance.getScheduleTime();
        }
        return new Date();
    }

    private List<DependentExecute> initializeDependentTaskList() {
        log.info("Begin to initialize dependent task list");
        List dependTaskList = this.dependentParameters.getDependence().getDependTaskList();
        HashSet<Long> projectCodes = new HashSet<Long>();
        HashSet<Long> processDefinitionCodes = new HashSet<Long>();
        HashSet<Long> taskDefinitionCodes = new HashSet<Long>();
        for (DependentTaskModel taskModel : dependTaskList) {
            for (DependentItem dependentItem : taskModel.getDependItemList()) {
                projectCodes.add(dependentItem.getProjectCode());
                processDefinitionCodes.add(dependentItem.getDefinitionCode());
                taskDefinitionCodes.add(dependentItem.getDepTaskCode());
            }
        }
        this.projectCodeMap = this.projectDao.queryByCodes(new ArrayList(projectCodes)).stream().collect(Collectors.toMap(Project::getCode, Function.identity()));
        this.processDefinitionMap = this.workflowDefinitionDao.queryByCodes(processDefinitionCodes).stream().collect(Collectors.toMap(WorkflowDefinition::getCode, Function.identity()));
        this.taskDefinitionMap = this.taskDefinitionDao.queryByCodes(taskDefinitionCodes).stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity()));
        TaskInstance taskInstance = (TaskInstance)this.taskInstanceDao.queryById((Serializable)Integer.valueOf(this.taskExecutionContext.getTaskInstanceId()));
        List<DependentExecute> dependentExecutes = dependTaskList.stream().map(dependentTaskModel -> {
            for (DependentItem dependentItem : dependentTaskModel.getDependItemList()) {
                Project project = this.projectCodeMap.get(dependentItem.getProjectCode());
                if (project == null) {
                    log.error("The dependent task's project is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's project is not exist, dependentItem: " + dependentItem);
                }
                WorkflowDefinition workflowDefinition = this.processDefinitionMap.get(dependentItem.getDefinitionCode());
                if (workflowDefinition == null) {
                    log.error("The dependent task's workflow is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's workflow is not exist, dependentItem: " + dependentItem);
                }
                if (dependentItem.getDepTaskCode() == -1L) {
                    log.info("Add dependent all task, ProjectName: {}, WorkflowName: {}, WorkflowCode: {}, DependentCycle: {}, DependentCycleDate: {}, DependentRelation: {}", new Object[]{project.getName(), workflowDefinition.getName(), workflowDefinition.getCode(), dependentItem.getCycle(), dependentItem.getDateValue(), dependentTaskModel.getRelation()});
                    continue;
                }
                if (dependentItem.getDepTaskCode() == 0L) {
                    log.info("Add dependent workflow task, ProjectName: {}, WorkflowName: {}, WorkflowCode: {}, DependentCycle: {}, DependentCycleDate: {}, DependentRelation: {}", new Object[]{project.getName(), workflowDefinition.getName(), workflowDefinition.getCode(), dependentItem.getCycle(), dependentItem.getDateValue(), dependentTaskModel.getRelation()});
                    continue;
                }
                TaskDefinition taskDefinition = this.taskDefinitionMap.get(dependentItem.getDepTaskCode());
                if (taskDefinition == null) {
                    log.error("The dependent task's taskDefinition is not exist, dependentItem: {}", (Object)dependentItem);
                    throw new RuntimeException("The dependent task's taskDefinition is not exist, dependentItem: " + dependentItem);
                }
                log.info("Add dependent task, ProjectName: {}, WorkflowName: {}, WorkflowCode: {}, TaskName: {}, DependentCycle: {}, DependentCycleDate: {}, DependentRelation: {}", new Object[]{project.getName(), workflowDefinition.getName(), workflowDefinition.getCode(), taskDefinition.getName(), dependentItem.getCycle(), dependentItem.getDateValue(), dependentTaskModel.getRelation()});
            }
            return new DependentExecute(dependentTaskModel.getDependItemList(), dependentTaskModel.getRelation(), this.workflowInstance, taskInstance);
        }).collect(Collectors.toList());
        log.info("Initialized dependent task list successfully");
        return dependentExecutes;
    }

    private void initTaskDependentResult() {
        this.taskInstanceContextDao.deleteByTaskInstanceIdAndContextType(Integer.valueOf(this.taskExecutionContext.getTaskInstanceId()), ContextType.DEPENDENT_RESULT_CONTEXT);
        this.taskInstanceContext.setTaskInstanceId(Integer.valueOf(this.taskExecutionContext.getTaskInstanceId()));
        this.taskInstanceContext.setContextType(ContextType.DEPENDENT_RESULT_CONTEXT);
        this.taskInstanceContext.setCreateTime(new Date());
        this.taskInstanceContext.setUpdateTime(new Date());
    }

    private DependResult calculateDependResult() {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        HashMap dependVarPoolEndTimeMap = new HashMap();
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            DependResult dependResult = dependentExecute.getModelDependResult(this.dependentDate);
            if (dependResult == DependResult.SUCCESS) {
                Map<String, Property> varPoolPropertyMap = dependentExecute.getDependTaskVarPoolPropertyMap();
                Map<String, Long> varPoolEndTimeMap = dependentExecute.getDependTaskVarPoolEndTimeMap();
                DependentUtils.addTaskVarPool(varPoolPropertyMap, varPoolEndTimeMap, this.dependVarPoolPropertyMap, dependVarPoolEndTimeMap);
            }
            dependResultList.add(dependResult);
        }
        return DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getDependence().getRelation(), dependResultList);
    }

    private boolean isAllDependentTaskFinished() {
        boolean isAllDependentTaskFinished = true;
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            if (!dependentExecute.finish(this.dependentDate, this.dependentParameters.getDependence().getFailurePolicy(), this.dependentParameters.getDependence().getFailureWaitingTime())) {
                isAllDependentTaskFinished = false;
            }
            dependentExecute.getDependResultMap().forEach((dependentKey, dependResult) -> {
                if (!this.dependResultMap.containsKey(dependentKey)) {
                    this.dependResultMap.put((String)dependentKey, (DependResult)dependResult);
                    DependentItem dependentItem = new DependentItem().fromKey(dependentKey);
                    WorkflowDefinition workflowDefinition = this.processDefinitionMap.get(dependentItem.getDefinitionCode());
                    Project project = this.projectCodeMap.get(workflowDefinition.getProjectCode());
                    DependentResultTaskInstanceContext dependentResultTaskInstanceContext = new DependentResultTaskInstanceContext();
                    dependentResultTaskInstanceContext.setProjectCode(Long.valueOf(project.getCode()));
                    dependentResultTaskInstanceContext.setWorkflowDefinitionCode(Long.valueOf(workflowDefinition.getCode()));
                    dependentResultTaskInstanceContext.setDependentResult(dependResult);
                    dependentResultTaskInstanceContext.setContextType(ContextType.DEPENDENT_RESULT_CONTEXT);
                    if (dependentItem.getDepTaskCode() == -1L) {
                        dependentResultTaskInstanceContext.setTaskDefinitionCode(Long.valueOf(-1L));
                        dependentResultTaskInstanceContext.setDateCycle(dependentItem.getDateValue());
                        this.taskInstanceContext.setTaskInstanceContext((List)Lists.newArrayList((Object[])new AbstractTaskInstanceContext[]{dependentResultTaskInstanceContext}));
                        this.taskInstanceContextDao.upsertTaskInstanceContext(this.taskInstanceContext);
                        log.info("Dependent type all task check finished, DependentResult: {}, DependentDate: {}, ProjectName: {}, WorkflowName: {}, WorkflowCode: {}, DependentCycle: {}, DependentCycleDate: {}", new Object[]{dependResult, this.dependentDate, project.getName(), workflowDefinition.getName(), workflowDefinition.getCode(), dependentItem.getCycle(), dependentItem.getDateValue()});
                    } else if (dependentItem.getDepTaskCode() == 0L) {
                        dependentResultTaskInstanceContext.setTaskDefinitionCode(Long.valueOf(0L));
                        dependentResultTaskInstanceContext.setDateCycle(dependentItem.getDateValue());
                        this.taskInstanceContext.setTaskInstanceContext((List)Lists.newArrayList((Object[])new AbstractTaskInstanceContext[]{dependentResultTaskInstanceContext}));
                        this.taskInstanceContextDao.upsertTaskInstanceContext(this.taskInstanceContext);
                        log.info("Dependent type workflow task check finished, DependentResult: {}, DependentDate: {}, ProjectName: {}, WorkflowName: {}, WorkflowCode: {}, DependentCycle: {}, DependentCycleDate: {}", new Object[]{dependResult, this.dependentDate, project.getName(), workflowDefinition.getName(), workflowDefinition.getCode(), dependentItem.getCycle(), dependentItem.getDateValue()});
                    } else {
                        TaskDefinition taskDefinition = this.taskDefinitionMap.get(dependentItem.getDepTaskCode());
                        dependentResultTaskInstanceContext.setTaskDefinitionCode(Long.valueOf(taskDefinition.getCode()));
                        dependentResultTaskInstanceContext.setDateCycle(dependentItem.getDateValue());
                        this.taskInstanceContext.setTaskInstanceContext((List)Lists.newArrayList((Object[])new AbstractTaskInstanceContext[]{dependentResultTaskInstanceContext}));
                        this.taskInstanceContextDao.upsertTaskInstanceContext(this.taskInstanceContext);
                        log.info("Dependent type task check finished, DependentResult: {}, DependentDate: {}, ProjectName: {}, WorkflowName: {}, WorkflowCode: {}, TaskName: {}, TaskCode: {}, DependentCycle: {}, DependentCycleDate: {}", new Object[]{dependResult, this.dependentDate, project.getName(), workflowDefinition.getName(), workflowDefinition.getCode(), taskDefinition.getName(), taskDefinition.getCode(), dependentItem.getCycle(), dependentItem.getDateValue()});
                    }
                }
            });
        }
        return isAllDependentTaskFinished;
    }
}

