/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.azure.resourcemanager.servicebus.fluent.models.SBSubscriptionInner;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.azure.resourcemanager.servicebus.models.Topic;
import java.time.Duration;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

class ServiceBusSubscriptionImpl
extends IndependentChildResourceImpl<ServiceBusSubscription, Topic, SBSubscriptionInner, ServiceBusSubscriptionImpl, ServiceBusManager>
implements ServiceBusSubscription,
ServiceBusSubscription.Definition,
ServiceBusSubscription.Update {
    private final String namespaceName;

    ServiceBusSubscriptionImpl(String resourceGroupName, String namespaceName, String topicName, String name, SBSubscriptionInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (Object)manager);
        this.namespaceName = namespaceName;
        this.withExistingParentResource(resourceGroupName, topicName);
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((SBSubscriptionInner)((Object)this.innerModel())).createdAt();
    }

    @Override
    public OffsetDateTime accessedAt() {
        return ((SBSubscriptionInner)((Object)this.innerModel())).accessedAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((SBSubscriptionInner)((Object)this.innerModel())).updatedAt();
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SBSubscriptionInner)((Object)this.innerModel())).enableBatchedOperations());
    }

    @Override
    public boolean isDeadLetteringEnabledForExpiredMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SBSubscriptionInner)((Object)this.innerModel())).deadLetteringOnMessageExpiration());
    }

    @Override
    public boolean isSessionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SBSubscriptionInner)((Object)this.innerModel())).requiresSession());
    }

    @Override
    public long lockDurationInSeconds() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).lockDuration() == null) {
            return 0L;
        }
        return ((SBSubscriptionInner)((Object)this.innerModel())).lockDuration().getSeconds();
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).autoDeleteOnIdle() == null) {
            return 0L;
        }
        return ((SBSubscriptionInner)((Object)this.innerModel())).autoDeleteOnIdle().toMinutes();
    }

    @Override
    public Duration defaultMessageTtlDuration() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).defaultMessageTimeToLive() == null) {
            return null;
        }
        return ((SBSubscriptionInner)((Object)this.innerModel())).defaultMessageTimeToLive();
    }

    @Override
    public int maxDeliveryCountBeforeDeadLetteringMessage() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SBSubscriptionInner)((Object)this.innerModel())).maxDeliveryCount());
    }

    @Override
    public long messageCount() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((SBSubscriptionInner)((Object)this.innerModel())).messageCount());
    }

    @Override
    public long activeMessageCount() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).countDetails() == null || ((SBSubscriptionInner)((Object)this.innerModel())).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SBSubscriptionInner)((Object)this.innerModel())).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).countDetails() == null || ((SBSubscriptionInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SBSubscriptionInner)((Object)this.innerModel())).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).countDetails() == null || ((SBSubscriptionInner)((Object)this.innerModel())).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SBSubscriptionInner)((Object)this.innerModel())).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).countDetails() == null || ((SBSubscriptionInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SBSubscriptionInner)((Object)this.innerModel())).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((SBSubscriptionInner)((Object)this.innerModel())).countDetails() == null || ((SBSubscriptionInner)((Object)this.innerModel())).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong((Long)((SBSubscriptionInner)((Object)this.innerModel())).countDetails().transferMessageCount());
    }

    @Override
    public EntityStatus status() {
        return ((SBSubscriptionInner)((Object)this.innerModel())).status();
    }

    @Override
    public boolean isDeadLetteringEnabledForFilterEvaluationFailedMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SBSubscriptionInner)((Object)this.innerModel())).deadLetteringOnFilterEvaluationExceptions());
    }

    @Override
    public ServiceBusSubscriptionImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        ((SBSubscriptionInner)((Object)this.innerModel())).withAutoDeleteOnIdle(Duration.ofMinutes(durationInMinutes));
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageLockDurationInSeconds(int durationInSeconds) {
        ((SBSubscriptionInner)((Object)this.innerModel())).withLockDuration(Duration.ofSeconds(durationInSeconds));
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withDefaultMessageTTL(Duration ttl) {
        ((SBSubscriptionInner)((Object)this.innerModel())).withDefaultMessageTimeToLive(ttl);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withSession() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withRequiresSession(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutSession() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withRequiresSession(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageBatching() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageBatching() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnMaxDeliveryCount(int deliveryCount) {
        ((SBSubscriptionInner)((Object)this.innerModel())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withDeadLetteringOnFilterEvaluationExceptions(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withDeadLetteringOnFilterEvaluationExceptions(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withExpiredMessageMovedToDeadLetterSubscription() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withDeadLetteringOnMessageExpiration(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutExpiredMessageMovedToDeadLetterSubscription() {
        ((SBSubscriptionInner)((Object)this.innerModel())).withDeadLetteringOnMessageExpiration(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int deliveryCount) {
        ((SBSubscriptionInner)((Object)this.innerModel())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    protected Mono<SBSubscriptionInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getSubscriptions().getAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name());
    }

    protected Mono<ServiceBusSubscription> createChildResourceAsync() {
        ServiceBusSubscriptionImpl self = this;
        return ((ServiceBusManagementClient)((ServiceBusManager)((Object)this.manager())).serviceClient()).getSubscriptions().createOrUpdateAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name(), (SBSubscriptionInner)((Object)this.innerModel())).map(inner -> {
            this.setInner(inner);
            return self;
        });
    }
}

