/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io.processors.charset;

import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderCreatesSurrogates;
import org.apache.daffodil.io.processors.charset.BitsCharsetDecoderMalformedException;

public class BitsCharsetDecoderUTF8
extends BitsCharsetDecoderCreatesSurrogates {
    @Override
    public char decodeOneUnicodeChar(InputSourceDataInputStream dis, FormatInfo finfo) {
        int byte1 = this.getByte(dis, 0);
        if ((byte1 & 0x80) == 0) {
            return (char)byte1;
        }
        if ((byte1 & 0xE0) == 192) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            this.checkOverlong(byte1, 31, 0, 0, 16);
            int cp = (byte1 & 0x1F) << 6 | byte2 & 0x3F;
            return (char)cp;
        }
        if ((byte1 & 0xF0) == 224) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            this.checkOverlong(byte1, 15, byte2, 32, 24);
            int cp = (byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F;
            if (cp >= 55296 && cp <= 57343) {
                throw new BitsCharsetDecoderMalformedException(24);
            }
            return (char)cp;
        }
        if ((byte1 & 0xF8) == 240) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            this.checkOverlong(byte1, 7, byte2, 48, 32);
            int cp = (byte1 & 0xF) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
            if (cp > 0x10FFFF) {
                throw new BitsCharsetDecoderMalformedException(32);
            }
            char high = Character.highSurrogate(cp);
            this.setLowSurrogate(Character.lowSurrogate(cp));
            return high;
        }
        if ((byte1 & 0xFC) == 248) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            int byte5 = this.getByte(dis, 32);
            this.checkContinuationByte(dis, byte5, 40);
            throw new BitsCharsetDecoderMalformedException(40);
        }
        if ((byte1 & 0xFE) == 252) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            int byte5 = this.getByte(dis, 32);
            this.checkContinuationByte(dis, byte5, 40);
            int byte6 = this.getByte(dis, 40);
            this.checkContinuationByte(dis, byte6, 48);
            throw new BitsCharsetDecoderMalformedException(48);
        }
        throw new BitsCharsetDecoderMalformedException(8);
    }

    public final void checkContinuationByte(InputSourceDataInputStream dis, int n, int bitsConsumedSoFar) {
        if ((n & 0xC0) != 128) {
            dis.setBitPos0b(dis.bitPos0b() - 8L);
            throw new BitsCharsetDecoderMalformedException(bitsConsumedSoFar - 8);
        }
    }

    public final void checkOverlong(int byte1, int mask1, int byte2, int mask2, int bitsConsumedSoFar) {
        if ((byte1 & mask1) == 0 && (byte2 & mask2) == 0) {
            throw new BitsCharsetDecoderMalformedException(bitsConsumedSoFar);
        }
    }
}

