/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class TestAbstractConfiguration {
    protected abstract AbstractConfiguration getConfiguration();

    protected abstract AbstractConfiguration getEmptyConfiguration();

    @Test
    public void givenNullIteratorTestContains() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertThrows(NullPointerException.class, () -> config.contains(null, (Object)"value1"));
    }

    @Test
    public void givenNullValueTestContains() {
        AbstractConfiguration config = this.getConfiguration();
        Iterator keys = config.getKeys();
        Assertions.assertFalse((boolean)config.contains(keys, null));
        Assertions.assertFalse((boolean)config.contains(keys, (Object)""));
    }

    @Test
    public void testAddPropertyDirect() {
        AbstractConfiguration config = this.getConfiguration();
        config.addPropertyDirect("key3", (Object)"value3");
        Assertions.assertEquals((Object)"value3", (Object)config.getProperty("key3"));
        config.addPropertyDirect("key3", (Object)"value4");
        config.addPropertyDirect("key3", (Object)"value5");
        List list = config.getList("key3");
        Assertions.assertNotNull((Object)list);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("value3");
        expected.add("value4");
        expected.add("value5");
        Assertions.assertEquals(expected, (Object)list);
    }

    @Test
    public void testClearProperty() {
        AbstractConfiguration config = this.getConfiguration();
        config.clearProperty("key2");
        Assertions.assertFalse((boolean)config.containsKey("key2"));
    }

    @Test
    void testContains() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertTrue((boolean)config.contains(config.getKeys(), (Object)"value1"));
        Assertions.assertFalse((boolean)config.contains(config.getKeys(), (Object)"value99999"));
    }

    @Test
    void testContainsKey() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertTrue((boolean)config.containsKey("key1"));
        Assertions.assertFalse((boolean)config.containsKey("key3"));
    }

    @Test
    public void testContainsValue() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertFalse((boolean)config.containsValue(null));
        Assertions.assertFalse((boolean)config.containsValue((Object)""));
        Assertions.assertTrue((boolean)config.containsValue((Object)"value1"));
        Assertions.assertFalse((boolean)config.containsValue((Object)"value99999"));
    }

    @Test
    void testGetBigIntegerConversion() {
        AbstractConfiguration config = this.getConfiguration();
        ConversionException cex = (ConversionException)Assertions.assertThrows(ConversionException.class, () -> TestAbstractConfiguration.lambda$testGetBigIntegerConversion$1((Configuration)config));
        Assertions.assertTrue((boolean)cex.getMessage().contains("'key1'"));
        Assertions.assertTrue((boolean)cex.getMessage().contains(BigInteger.class.getName()));
        Assertions.assertTrue((boolean)cex.getMessage().contains(config.getString("key1")));
    }

    @Test
    void testGetKeys() {
        AbstractConfiguration config = this.getConfiguration();
        Iterator keys = config.getKeys();
        HashSet<String> expectedKeys = new HashSet<String>(Arrays.asList("key1", "key2", "list", "listesc"));
        Assertions.assertNotNull((Object)keys);
        Assertions.assertTrue((boolean)keys.hasNext());
        HashSet<String> actualKeys = new HashSet<String>();
        while (keys.hasNext()) {
            actualKeys.add((String)keys.next());
        }
        Assertions.assertEquals(actualKeys, expectedKeys, (String)"keys");
    }

    @Test
    void testGetProperty() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertEquals((Object)"value1", (Object)config.getProperty("key1"));
        Assertions.assertEquals((Object)"value2", (Object)config.getProperty("key2"));
        Assertions.assertNull((Object)config.getProperty("key3"));
    }

    @Test
    void testIsEmpty() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertFalse((boolean)config.isEmpty());
        Assertions.assertTrue((boolean)this.getEmptyConfiguration().isEmpty());
    }

    @Test
    void testList() {
        AbstractConfiguration config = this.getConfiguration();
        List list = config.getList("list");
        Assertions.assertNotNull((Object)config.getProperty("list"));
        Assertions.assertEquals(Arrays.asList("value1", "value2"), (Object)list);
    }

    @Test
    void testListEscaped() {
        Assertions.assertEquals((Object)"value1,value2", (Object)this.getConfiguration().getString("listesc"));
    }

    @Test
    void testSetLogger() {
        AbstractConfiguration config = this.getEmptyConfiguration();
        Assertions.assertNotNull((Object)config.getLogger());
        ConfigurationLogger log = new ConfigurationLogger(config.getClass());
        config.setLogger(log);
        Assertions.assertSame((Object)log, (Object)config.getLogger());
    }

    @Test
    void testSize() {
        Assertions.assertEquals((int)4, (int)this.getConfiguration().size());
    }

    @Test
    void testSizeEmpty() {
        Assertions.assertEquals((int)0, (int)this.getEmptyConfiguration().size());
    }

    private static /* synthetic */ void lambda$testGetBigIntegerConversion$1(Configuration config) throws Throwable {
        config.getBigInteger("key1");
    }
}

