/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.sasl.SaslClientBootstrap;
import org.apache.celeborn.common.network.sasl.SaslServerBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationClientBootstrap;
import org.apache.celeborn.common.network.sasl.registration.RegistrationServerBootstrap;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.server.TransportServerBootstrap;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.rpc.ClientSaslContext;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointNotFoundException;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcEnvConfig;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.RpcSecurityContext;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.rpc.ServerSaslContext;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv$;
import org.apache.celeborn.common.rpc.netty.NettyRpcHandler;
import org.apache.celeborn.common.rpc.netty.OneWayOutboxMessage;
import org.apache.celeborn.common.rpc.netty.Outbox;
import org.apache.celeborn.common.rpc.netty.OutboxMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcFailure;
import org.apache.celeborn.common.rpc.netty.RpcOutboxMessage;
import org.apache.celeborn.common.serializer.JavaSerializerInstance;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u0001\u0003\u0001=\u00111BT3uif\u0014\u0006oY#om*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t1A\u001d9d\u0015\t9\u0001\"\u0001\u0004d_6lwN\u001c\u0006\u0003\u0013)\t\u0001bY3mK\n|'O\u001c\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001B\u0003\u0005\u0002\u0012%5\tA!\u0003\u0002\u0014\t\t1!\u000b]2F]Z\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oO\"A1\u0004\u0001BC\u0002\u0013\u0005A$\u0001\u0004d_:4\u0017nZ\u000b\u0002;A\u0011\u0011CH\u0005\u0003?\u0011\u0011AB\u00159d\u000b:48i\u001c8gS\u001eD\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013A\u00066bm\u0006\u001cVM]5bY&TXM]%ogR\fgnY3\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d2\u0011AC:fe&\fG.\u001b>fe&\u0011\u0011F\n\u0002\u0017\u0015\u00064\u0018mU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\")1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"2!L\u00181!\tq\u0003!D\u0001\u0003\u0011\u0015Y\"\u00061\u0001\u001e\u0011\u0015\u0019#\u00061\u0001%\u0011\u001d\u0011\u0004A1A\u0005\u0002M\nAbY3mK\n|'O\\\"p]\u001a,\u0012\u0001\u000e\t\u0003kYj\u0011AB\u0005\u0003o\u0019\u0011AbQ3mK\n|'O\\\"p]\u001aDa!\u000f\u0001!\u0002\u0013!\u0014!D2fY\u0016\u0014wN\u001d8D_:4\u0007\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\u001fM,7-\u001e:jif\u001cuN\u001c;fqR,\u0012!\u0010\t\u0004}\u0005\u001bU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r=\u0003H/[8o!\t\tB)\u0003\u0002F\t\t\u0011\"\u000b]2TK\u000e,(/\u001b;z\u0007>tG/\u001a=u\u0011\u00199\u0005\u0001)A\u0005{\u0005\u00012/Z2ve&$\u0018pQ8oi\u0016DH\u000f\t\u0005\t\u0013\u0002\u0011\r\u0011\"\u0001\t\u0015\u0006iAO]1ogB|'\u000f^\"p]\u001a,\u0012a\u0013\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bA!\u001e;jY*\u0011\u0001KB\u0001\b]\u0016$xo\u001c:l\u0013\t\u0011VJA\u0007Ue\u0006t7\u000f]8si\u000e{gN\u001a\u0005\u0007)\u0002\u0001\u000b\u0011B&\u0002\u001dQ\u0014\u0018M\\:q_J$8i\u001c8gA!9a\u000b\u0001b\u0001\n\u00139\u0016A\u00033jgB\fGo\u00195feV\t\u0001\f\u0005\u0002/3&\u0011!L\u0001\u0002\u000b\t&\u001c\b/\u0019;dQ\u0016\u0014\bB\u0002/\u0001A\u0003%\u0001,A\u0006eSN\u0004\u0018\r^2iKJ\u0004\u0003b\u00020\u0001\u0001\u0004%IaX\u0001\u0007o>\u00148.\u001a:\u0016\u0003\u0001\u0004\"!E1\n\u0005\t$!a\u0003*qG\u0016sG\r]8j]RDq\u0001\u001a\u0001A\u0002\u0013%Q-\u0001\u0006x_J\\WM]0%KF$\"AZ5\u0011\u0005y:\u0017B\u00015@\u0005\u0011)f.\u001b;\t\u000f)\u001c\u0017\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\t\r1\u0004\u0001\u0015)\u0003a\u0003\u001d9xN]6fe\u0002B\u0001B\u001c\u0001C\u0002\u0013\u0005!a\\\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR,\u0012\u0001\u001d\t\u0003cJl\u0011aT\u0005\u0003g>\u0013\u0001\u0003\u0016:b]N\u0004xN\u001d;D_:$X\r\u001f;\t\rU\u0004\u0001\u0015!\u0003q\u0003E!(/\u00198ta>\u0014HoQ8oi\u0016DH\u000f\t\u0005\u0006o\u0002!I\u0001_\u0001\u0017GJ,\u0017\r^3DY&,g\u000e\u001e\"p_R\u001cHO]1qgR\t\u0011\u0010\u0005\u0003{}\u0006\u0005Q\"A>\u000b\u00059c(\"A?\u0002\t)\fg/Y\u0005\u0003\u007fn\u0014A\u0001T5tiB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b=\u000baa\u00197jK:$\u0018\u0002BA\u0006\u0003\u000b\u0011\u0001\u0004\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\"p_R\u001cHO]1q\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\"A\u0007dY&,g\u000e\u001e$bGR|'/_\u000b\u0003\u0003'\u0001B!a\u0001\u0002\u0016%!\u0011qCA\u0003\u0005Y!&/\u00198ta>\u0014Ho\u00117jK:$h)Y2u_JL\b\u0002CA\u000e\u0001\u0001\u0006I!a\u0005\u0002\u001d\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:zA!I\u0011q\u0004\u0001C\u0002\u0013%\u0011\u0011E\u0001\u0011i&lWm\\;u'\u000eDW\rZ;mKJ,\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b|\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003[\t9C\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001\"!\r\u0001A\u0003%\u00111E\u0001\u0012i&lWm\\;u'\u000eDW\rZ;mKJ\u0004\u0003BCA\u001b\u0001\t\u0007I\u0011\u0001\u0005\u00028\u0005A2\r\\5f]R\u001cuN\u001c8fGRLwN\\#yK\u000e,Ho\u001c:\u0016\u0005\u0005e\u0002\u0003BA\u0013\u0003wIA!!\u0010\u0002(\t\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0011!\t\t\u0005\u0001Q\u0001\n\u0005e\u0012!G2mS\u0016tGoQ8o]\u0016\u001cG/[8o\u000bb,7-\u001e;pe\u0002B1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H\u000511/\u001a:wKJ,\"!!\u0013\u0011\t\u0005-\u0013qJ\u0007\u0003\u0003\u001bR1!!\u0012P\u0013\u0011\t\t&!\u0014\u0003\u001fQ\u0013\u0018M\\:q_J$8+\u001a:wKJD1\"!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X\u0005Q1/\u001a:wKJ|F%Z9\u0015\u0007\u0019\fI\u0006C\u0005k\u0003'\n\t\u00111\u0001\u0002J!A\u0011Q\f\u0001!B\u0013\tI%A\u0004tKJ4XM\u001d\u0011)\t\u0005m\u0013\u0011\r\t\u0004}\u0005\r\u0014bAA3\u007f\tAao\u001c7bi&dW\rC\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l\u000591\u000f^8qa\u0016$WCAA7!\u0011\ty'!\u001e\u000e\u0005\u0005E$\u0002BA:\u0003O\ta!\u0019;p[&\u001c\u0017\u0002BA<\u0003c\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA>\u0001\u0001\u0006I!!\u001c\u0002\u0011M$x\u000e\u001d9fI\u0002B\u0011\"a \u0001\u0005\u0004%I!!!\u0002\u0011=,HOY8yKN,\"!a!\u0011\u0011\u0005\u0015\u0012QQAE\u0003\u001fKA!a\"\u0002(\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007E\tY)C\u0002\u0002\u000e\u0012\u0011!B\u00159d\u0003\u0012$'/Z:t!\rq\u0013\u0011S\u0005\u0004\u0003'\u0013!AB(vi\n|\u0007\u0010\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAB\u0003%yW\u000f\u001e2pq\u0016\u001c\b\u0005\u0003\u0005\u0002\u001c\u0002!\t\u0001CAO\u00031\u0011X-\\8wK>+HOY8y)\r1\u0017q\u0014\u0005\t\u0003C\u000bI\n1\u0001\u0002\n\u00069\u0011\r\u001a3sKN\u001c\bbBAS\u0001\u0011%\u0011qU\u0001\u0017GJ,\u0017\r^3TKJ4XM\u001d\"p_R\u001cHO]1qgR\u0011\u0011\u0011\u0016\t\u0005uz\fY\u000b\u0005\u0003\u0002L\u00055\u0016\u0002BAX\u0003\u001b\u0012\u0001\u0004\u0016:b]N\u0004xN\u001d;TKJ4XM\u001d\"p_R\u001cHO]1q\u0011\u001d\t\u0019\f\u0001C\u0001\u0003k\u000b1b\u001d;beR\u001cVM\u001d<feR)a-a.\u0002J\"A\u0011\u0011XAY\u0001\u0004\tY,A\u0006cS:$\u0017\t\u001a3sKN\u001c\b\u0003BA_\u0003\u0007t1APA`\u0013\r\t\tmP\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0017q\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005w\b\u0003\u0005\u0002L\u0006E\u0006\u0019AAg\u0003\u0011\u0001xN\u001d;\u0011\u0007y\ny-C\u0002\u0002R~\u00121!\u00138u\u0011)\t\t\u000b\u0001EC\u0002\u0013\u0005\u0013Q[\u000b\u0003\u0003\u0013C!\"!7\u0001\u0011\u0003\u0005\u000b\u0015BAE\u0003!\tG\r\u001a:fgN\u0004\u0003\u0006BAl\u0003;\u0004B!a8\u0002j6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/\u0001\u0006b]:|G/\u0019;j_:T!!a:\u0002\u000b)\fg/\u0019=\n\t\u0005-\u0018\u0011\u001d\u0002\t\u001dVdG.\u00192mK\"9\u0011q\u001e\u0001\u0005B\u0005E\u0018!D:fiV\u0004XI\u001c3q_&tG\u000f\u0006\u0004\u0002t\u0006e\u0018Q \t\u0004#\u0005U\u0018bAA|\t\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\u0002CA~\u0003[\u0004\r!a/\u0002\t9\fW.\u001a\u0005\b\u0003\u007f\fi\u000f1\u0001a\u0003!)g\u000e\u001a9pS:$\bb\u0002B\u0002\u0001\u0011\u0005!QA\u0001\u0010G\",7m\u001b*fO&\u001cH/\u001a:fIR\u0011!q\u0001\t\u0004}\t%\u0011b\u0001B\u0006\u007f\t9!i\\8mK\u0006t\u0007b\u0002B\b\u0001\u0011\u0005!\u0011C\u0001\u001cCNLhnY*fiV\u0004XI\u001c3q_&tGOU3g\u0005f\fE\r\u001a:\u0015\t\tM!Q\u0004\t\u0007\u0005+\u0011I\"a=\u000e\u0005\t]!bAA\u0015\u007f%!!1\u0004B\f\u0005\u00191U\u000f^;sK\"A!q\u0004B\u0007\u0001\u0004\u0011\t#\u0001\u0003bI\u0012\u0014\bcA\t\u0003$%\u0019!Q\u0005\u0003\u0003%I\u00038-\u00128ea>Lg\u000e^!eIJ,7o\u001d\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0003\u0011\u0019Ho\u001c9\u0015\u0007\u0019\u0014i\u0003\u0003\u0005\u00030\t\u001d\u0002\u0019AAz\u0003-)g\u000e\u001a9pS:$(+\u001a4\t\u000f\tM\u0002\u0001\"\u0003\u00036\u0005a\u0001o\\:u)>|U\u000f\u001e2pqR)aMa\u000e\u0003B!A!\u0011\bB\u0019\u0001\u0004\u0011Y$\u0001\u0005sK\u000e,\u0017N^3s!\rq#QH\u0005\u0004\u0005\u007f\u0011!a\u0005(fiRL(\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\u0002\u0003B\"\u0005c\u0001\rA!\u0012\u0002\u000f5,7o]1hKB\u0019aFa\u0012\n\u0007\t%#AA\u0007PkR\u0014w\u000e_'fgN\fw-\u001a\u0005\t\u0005\u001b\u0002A\u0011\u0001\u0005\u0003P\u0005!1/\u001a8e)\r1'\u0011\u000b\u0005\t\u0005\u0007\u0012Y\u00051\u0001\u0003TA\u0019aF!\u0016\n\u0007\t]#A\u0001\bSKF,Xm\u001d;NKN\u001c\u0018mZ3\t\u0011\tm\u0003\u0001\"\u0001\t\u0005;\nAb\u0019:fCR,7\t\\5f]R$BAa\u0018\u0003fA!\u00111\u0001B1\u0013\u0011\u0011\u0019'!\u0002\u0003\u001fQ\u0013\u0018M\\:q_J$8\t\\5f]RD\u0001\"!)\u0003Z\u0001\u0007\u0011\u0011\u0012\u0005\t\u0005S\u0002A\u0011\u0001\u0005\u0003l\u0005\u0019\u0011m]6\u0016\t\t5$q\u000f\u000b\u0007\u0005_\u0012IJa'\u0015\t\tE$\u0011\u0012\t\u0007\u0005+\u0011IBa\u001d\u0011\t\tU$q\u000f\u0007\u0001\t!\u0011IHa\u001aC\u0002\tm$!\u0001+\u0012\t\tu$1\u0011\t\u0004}\t}\u0014b\u0001BA\u007f\t9aj\u001c;iS:<\u0007c\u0001 \u0003\u0006&\u0019!qQ \u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0003\f\n\u001d\u0014\u0011!a\u0002\u0005\u001b\u000b!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\u0011yI!&\u0003t5\u0011!\u0011\u0013\u0006\u0004\u0005'{\u0014a\u0002:fM2,7\r^\u0005\u0005\u0005/\u0013\tJ\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011!\u0011\u0019Ea\u001aA\u0002\tM\u0003\u0002\u0003BO\u0005O\u0002\rAa(\u0002\u000fQLW.Z8viB\u0019\u0011C!)\n\u0007\t\rFA\u0001\u0006Sa\u000e$\u0016.\\3pkRD\u0001Ba*\u0001\t\u0003A!\u0011V\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$BAa+\u00038B!!Q\u0016BZ\u001b\t\u0011yKC\u0002\u00032r\f1A\\5p\u0013\u0011\u0011)La,\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0005\u0003:\n\u0015\u0006\u0019\u0001BB\u0003\u001d\u0019wN\u001c;f]RD\u0001B!0\u0001\t\u0003A!qX\u0001\u0010g\u0016\u0014\u0018.\u00197ju\u0016\u001cFO]3b[R!!\u0011\u0019Bd!\r)#1Y\u0005\u0004\u0005\u000b4#aE*fe&\fG.\u001b>bi&|gn\u0015;sK\u0006l\u0007\u0002\u0003Be\u0005w\u0003\rAa3\u0002\u0007=,H\u000f\u0005\u0003\u0003N\nMWB\u0001Bh\u0015\r\u0011\t\u000e`\u0001\u0003S>LAA!6\u0003P\naq*\u001e;qkR\u001cFO]3b[\"A!\u0011\u001c\u0001\u0005\u0002!\u0011Y.A\u0006eKN,'/[1mSj,W\u0003\u0002Bo\u0005G$bAa8\u0003l\n5H\u0003\u0002Bq\u0005K\u0004BA!\u001e\u0003d\u0012A!\u0011\u0010Bl\u0005\u0004\u0011Y\b\u0003\u0006\u0003h\n]\u0017\u0011!a\u0002\u0005S\f!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\u0011yI!&\u0003b\"A\u0011q\u0001Bl\u0001\u0004\u0011y\u0006\u0003\u0005\u0003p\n]\u0007\u0019\u0001BV\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\u0011y\u0003\u0001C!\u0005g$B!a=\u0003v\"9\u0011q By\u0001\u0004\u0001\u0007b\u0002B}\u0001\u0011\u0005#1`\u0001\tg\",H\u000fZ8x]R\ta\rC\u0004\u0003\u0000\u0002!\tEa?\u0002!\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>t\u0007bBB\u0002\u0001\u0011%!1`\u0001\bG2,\u0017M\\;q\u0011\u001d\u0011I\u000e\u0001C!\u0007\u000f)Ba!\u0003\u0004\u000eQ!11BB\b!\u0011\u0011)h!\u0004\u0005\u0011\te4Q\u0001b\u0001\u0005wB\u0001b!\u0005\u0004\u0006\u0001\u000711C\u0001\u0016I\u0016\u001cXM]5bY&T\u0018\r^5p]\u0006\u001bG/[8o!\u0015q4QCB\u0006\u0013\r\u00199b\u0010\u0002\n\rVt7\r^5p]B:\u0001ba\u0007\u0003\u0011\u0003A1QD\u0001\f\u001d\u0016$H/\u001f*qG\u0016sg\u000fE\u0002/\u0007?1q!\u0001\u0002\t\u0002!\u0019\tcE\u0003\u0004 \r\rB\u0003E\u0002?\u0007KI1aa\n@\u0005\u0019\te.\u001f*fM\"91fa\b\u0005\u0002\r-BCAB\u000f\u0011-\u0019yca\bC\u0002\u0013\u0005\u0001b!\r\u0002\u0015\r,(O]3oi\u0016sg/\u0006\u0002\u00044A)1QGB\u001d[5\u00111q\u0007\u0006\u0003\u001d~JAaa\u000f\u00048\tyA)\u001f8b[&\u001cg+\u0019:jC\ndW\rC\u0005\u0004@\r}\u0001\u0015!\u0003\u00044\u0005Y1-\u001e:sK:$XI\u001c<!\u0011-\u0019\u0019ea\bC\u0002\u0013\u0005\u0001b!\u0012\u0002\u001b\r,(O]3oi\u000ec\u0017.\u001a8u+\t\u00199\u0005\u0005\u0004\u00046\re\"q\f\u0005\n\u0007\u0017\u001ay\u0002)A\u0005\u0007\u000f\nabY;se\u0016tGo\u00117jK:$\b\u0005")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final RpcEnvConfig config;
    public final JavaSerializerInstance org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance;
    private final CelebornConf celebornConf;
    private final Option<RpcSecurityContext> securityContext;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private RpcEndpoint worker;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private final transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.config().advertiseAddress(), this.server().getPort());
                this.bitmap$0 = true;
            }
            return this.address;
        }
    }

    private Logger log$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public RpcEnvConfig config() {
        return this.config;
    }

    public CelebornConf celebornConf() {
        return this.celebornConf;
    }

    public Option<RpcSecurityContext> securityContext() {
        return this.securityContext;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private RpcEndpoint worker() {
        return this.worker;
    }

    private void worker_$eq(RpcEndpoint x$1) {
        this.worker = x$1;
    }

    public TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;

            public final Option<TransportClientBootstrap> apply(RpcSecurityContext x$1) {
                return x$1.clientSaslContext().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final TransportClientBootstrap apply(ClientSaslContext clientSaslContext) {
                        TransportClientBootstrap transportClientBootstrap;
                        if (clientSaslContext.addRegistrationBootstrap()) {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add registration client bootstrap";
                                }
                            });
                            transportClientBootstrap = new RegistrationClientBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials(), clientSaslContext.registrationInfo());
                        } else {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add sasl client bootstrap";
                                }
                            });
                            transportClientBootstrap = new SaslClientBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), clientSaslContext.appId(), clientSaslContext.saslCredentials());
                        }
                        return transportClientBootstrap;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        Outbox outbox = this.outboxes().remove(address);
        if (outbox != null) {
            outbox.stop();
        }
    }

    private List<TransportServerBootstrap> createServerBootstraps() {
        Option bootstrapOpt = this.securityContext().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;

            public final Option<TransportServerBootstrap> apply(RpcSecurityContext x$2) {
                return x$2.serverSaslContext().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final TransportServerBootstrap apply(ServerSaslContext serverSaslContext) {
                        TransportServerBootstrap transportServerBootstrap;
                        if (serverSaslContext.addRegistrationBootstrap()) {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add registration server bootstrap";
                                }
                            });
                            transportServerBootstrap = new RegistrationServerBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), serverSaslContext.secretRegistry());
                        } else {
                            this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Add sasl server bootstrap";
                                }
                            });
                            transportServerBootstrap = new SaslServerBootstrap(this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().transportConf(), serverSaslContext.secretRegistry());
                        }
                        return transportServerBootstrap;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstrapOpt.toList()).asJava();
    }

    public void startServer(String bindAddress, int port) {
        this.server_$eq(this.transportContext().createServer(bindAddress, port, this.createServerBootstraps()));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        block3: {
            block2: {
                String string = name;
                String string2 = RpcNameConstants.WORKER_EP;
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = name;
                String string4 = RpcNameConstants.WORKER_INTERNAL_EP;
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.worker_$eq(endpoint);
        }
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    public boolean checkRegistered() {
        return this.worker() == null ? true : this.worker().checkRegistered();
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByAddr(RpcEndpointAddress addr) {
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.celebornConf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(addr.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, addr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            private final RpcEndpointAddress addr$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)new NettyRpcEndpointRef(this.$outer.celebornConf(), this.addr$1, this.$outer)) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.addr$1.toString()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.addr$1 = addr$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() != null && receiver.client().isActive()) {
            message.sendWith(receiver.client());
        } else {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
                return;
            }
            catch (RpcEnvStoppedException rpcEnvStoppedException) {
                this.logDebug((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException e$1;

                    public final String apply() {
                        return this.e$1.getMessage();
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                return;
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
            return;
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Try<Object> x0$1) {
                        Try<Object> try_;
                        block4: {
                            block3: {
                                block2: {
                                    try_ = x0$1;
                                    if (!(try_ instanceof Success)) break block2;
                                    Success success = (Success)try_;
                                    Object response = success.value();
                                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(response, this.promise$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(try_ instanceof Failure)) break block4;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(Throwable e) {
                        this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)new Serializable(this, promise){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ NettyRpcEnv $outer;
                    private final Promise promise$1;

                    public final void apply(TransportClient client, ByteBuffer response) {
                        this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(this.$outer.deserialize(client, response, ClassTag$.MODULE$.Any()), this.promise$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.promise$1 = promise$1;
                    }
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1)new Serializable(this, rpcMessage){
                    public static final long serialVersionUID = 0L;
                    private final RpcOutboxMessage rpcMessage$1;

                    public final void apply(Throwable x0$2) {
                        Throwable throwable = x0$2;
                        if (throwable instanceof TimeoutException) {
                            this.rpcMessage$1.onTimeout();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        this.rpcMessage$1 = rpcMessage$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise, remoteAddr){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;
                private final RpcAddress remoteAddr$1;

                public void run() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot receive any reply from ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddr$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timeout$1.duration()}))).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                    this.remoteAddr$1 = remoteAddr$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1)new Serializable(this, timeoutCancelable){
                public static final long serialVersionUID = 0L;
                private final ScheduledFuture timeoutCancelable$1;

                public final boolean apply(Try<Object> v) {
                    return this.timeoutCancelable$1.cancel(true);
                }
                {
                    this.timeoutCancelable$1 = timeoutCancelable$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final ByteBuffer bytes$1;
            public final ClassTag evidence$2$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance.deserialize(this.$outer.bytes$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            if (this.transportContext() != null) {
                this.transportContext().close();
            }
            if (this.clientConnectionExecutor() != null) {
                this.clientConnectionExecutor().shutdownNow();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)new Serializable(this, rpcEnvStoppedException){
                    public static final long serialVersionUID = 0L;
                    private final RpcEnvStoppedException x2$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1}));
                    }
                    {
                        this.x2$1 = x2$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2}));
                    }
                    {
                        this.e$2 = e$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onSuccess$1(Object reply2, Promise promise$1) {
        Object object = reply2;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (promise$1.trySuccess(object)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, reply2){
                    public static final long serialVersionUID = 0L;
                    private final Object reply$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1}));
                    }
                    {
                        this.reply$1 = reply$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public NettyRpcEnv(RpcEnvConfig config, JavaSerializerInstance javaSerializerInstance) {
        this.config = config;
        this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$javaSerializerInstance = javaSerializerInstance;
        super(config);
        Logging$class.$init$(this);
        this.celebornConf = config.conf();
        this.securityContext = config.securityContext();
        this.transportConf = Utils$.MODULE$.fromCelebornConf(this.celebornConf().clone(), config.transportModule(), BoxesRunTime.unboxToInt((Object)this.celebornConf().rpcIoThreads().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.config().numUsableCores();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })));
        this.dispatcher = new Dispatcher(this);
        this.worker = null;
        this.transportContext = new TransportContext(this.transportConf(), new NettyRpcHandler(this.dispatcher(), this));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("celeborn-netty-rpc-env-timeout-checker");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-netty-rpc-connection-executor", this.celebornConf().rpcConnectThreads(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = JavaUtils.newConcurrentHashMap();
    }
}

