/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.validation;

import java.util.function.Supplier;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.modeler.editor.validation.AttributeValidationFailure;
import org.apache.cayenne.modeler.editor.wrapper.ObjAttributeWrapper;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.validation.ValidationResult;

public class ObjAttributeWrapperValidator
extends ConfigurationNodeValidator<ObjAttributeWrapper> {
    public ObjAttributeWrapperValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(ObjAttributeWrapper node, ValidationResult validationResult) {
        this.validateName(node, validationResult);
    }

    private void validateName(ObjAttributeWrapper wrapper, ValidationResult validationResult) {
        if (this.isAttributeNameOverlapped(wrapper)) {
            this.addFailure(validationResult, new AttributeValidationFailure(0, "Duplicate attribute name."));
        }
    }

    private boolean isAttributeNameOverlapped(ObjAttributeWrapper wrapper) {
        ObjAttribute otherAttribute = wrapper.getEntity().getAttributeMap().get(wrapper.getName());
        return otherAttribute != null && wrapper.getValue() != otherAttribute;
    }
}

