package org.apache.cayenne.testdo.date_time.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.DateProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.testdo.date_time.DateTestEntity;

/**
 * Class _DateTestEntity was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _DateTestEntity extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<DateTestEntity> SELF = PropertyFactory.createSelf(DateTestEntity.class);

    public static final NumericIdProperty<Integer> DATE_TEST_ID_PK_PROPERTY = PropertyFactory.createNumericId("DATE_TEST_ID", "DateTestEntity", Integer.class);
    public static final String DATE_TEST_ID_PK_COLUMN = "DATE_TEST_ID";

    public static final DateProperty<Date> DATE_COLUMN = PropertyFactory.createDate("dateColumn", Date.class);
    public static final DateProperty<Date> TIME_COLUMN = PropertyFactory.createDate("timeColumn", Date.class);
    public static final DateProperty<Date> TIMESTAMP_COLUMN = PropertyFactory.createDate("timestampColumn", Date.class);

    protected Date dateColumn;
    protected Date timeColumn;
    protected Date timestampColumn;


    public void setDateColumn(Date dateColumn) {
        beforePropertyWrite("dateColumn", this.dateColumn, dateColumn);
        this.dateColumn = dateColumn;
    }

    public Date getDateColumn() {
        beforePropertyRead("dateColumn");
        return this.dateColumn;
    }

    public void setTimeColumn(Date timeColumn) {
        beforePropertyWrite("timeColumn", this.timeColumn, timeColumn);
        this.timeColumn = timeColumn;
    }

    public Date getTimeColumn() {
        beforePropertyRead("timeColumn");
        return this.timeColumn;
    }

    public void setTimestampColumn(Date timestampColumn) {
        beforePropertyWrite("timestampColumn", this.timestampColumn, timestampColumn);
        this.timestampColumn = timestampColumn;
    }

    public Date getTimestampColumn() {
        beforePropertyRead("timestampColumn");
        return this.timestampColumn;
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "dateColumn":
                return this.dateColumn;
            case "timeColumn":
                return this.timeColumn;
            case "timestampColumn":
                return this.timestampColumn;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "dateColumn":
                this.dateColumn = (Date)val;
                break;
            case "timeColumn":
                this.timeColumn = (Date)val;
                break;
            case "timestampColumn":
                this.timestampColumn = (Date)val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.dateColumn);
        out.writeObject(this.timeColumn);
        out.writeObject(this.timestampColumn);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.dateColumn = (Date)in.readObject();
        this.timeColumn = (Date)in.readObject();
        this.timestampColumn = (Date)in.readObject();
    }

}
