/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.config.SchemaFeature;
import org.apache.cassandra.spark.sparksql.LastModifiedTimestampDecorator;
import org.apache.cassandra.spark.sparksql.RowBuilder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public enum SchemaFeatureSet implements SchemaFeature
{
    LAST_MODIFIED_TIMESTAMP{

        @Override
        public DataType fieldDataType() {
            return DataTypes.TimestampType;
        }

        @Override
        public <T extends InternalRow> RowBuilder<T> decorate(RowBuilder<T> builder) {
            return new LastModifiedTimestampDecorator<T>(builder, this.fieldName());
        }
    };


    public static List<SchemaFeature> initializeFromOptions(Map<String, String> options) {
        return Arrays.stream(SchemaFeatureSet.values()).filter(feature -> Boolean.parseBoolean(options.getOrDefault(feature.optionName(), "false").toLowerCase())).collect(Collectors.toList());
    }
}

