/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.common.schema;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.spark.common.schema.CollectionType;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnUtil;

public class MapType<K, V>
extends CollectionType<Map.Entry<K, V>, Map.Entry<K, V>> {
    public final ColumnType<K> keyType;
    public final ColumnType<V> valueType;

    public MapType(ColumnType<K> keyType, ColumnType<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public Map.Entry<K, V> parseCollectionColumn(ByteBuffer colNameSuffix, ByteBuffer colValue) {
        final K key = ColumnUtil.getField(colNameSuffix, this.keyType);
        final V value = ColumnUtil.parseSingleColumn(this.valueType, colValue);
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(Object value2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<Map.Entry<K, V>> finaliseCollection(List<Map.Entry<K, V>> entryList) {
        return entryList;
    }
}

