/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import o.a.c.sidecar.client.shaded.common.data.ConsistencyVerificationResult;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobProgressFetchPolicy;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobStatus;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateRestoreJobRequestPayload;
import o.a.c.sidecar.client.shaded.common.response.data.RestoreJobProgressResponsePayload;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.ImportCoordinator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.apache.cassandra.spark.exception.ConsistencyNotSatisfiedException;
import org.apache.cassandra.spark.exception.ImportFailedException;
import org.apache.cassandra.spark.transports.storage.extensions.CoordinationSignalListener;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportExtension;
import org.apache.cassandra.spark.transports.storage.extensions.TransportExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatedImportCoordinator
implements ImportCoordinator,
CoordinationSignalListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinatedImportCoordinator.class);
    private final long startTimeNanos;
    private final CoordinatedCloudStorageDataTransferApi dataTransferApi;
    private final JobInfo job;
    private final StorageTransportExtension extension;
    private final CompletableFuture<RestoreJobStatus> stageReady = new CompletableFuture();
    private final CompletableFuture<RestoreJobStatus> importReady = new CompletableFuture();
    private final Set<String> stageCompletedClusters;
    private final Set<String> importCompletedClusters;
    private volatile boolean succeeded = false;
    private volatile ImportFailedException importFailedException = null;

    @VisibleForTesting
    CoordinatedImportCoordinator(long startTimeNanos, JobInfo job, CoordinatedCloudStorageDataTransferApi dataTransferApi, StorageTransportExtension extension) {
        this.startTimeNanos = startTimeNanos;
        this.job = job;
        this.dataTransferApi = dataTransferApi;
        this.stageCompletedClusters = ConcurrentHashMap.newKeySet(dataTransferApi.size());
        this.importCompletedClusters = ConcurrentHashMap.newKeySet(dataTransferApi.size());
        this.extension = extension;
    }

    public static CoordinatedImportCoordinator of(long startTimeNanos, JobInfo job, CoordinatedCloudStorageDataTransferApi dataTransferApi, StorageTransportExtension extension) {
        return new CoordinatedImportCoordinator(startTimeNanos, job, dataTransferApi, extension);
    }

    @Override
    public boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public ImportFailedException failure() {
        return this.importFailedException;
    }

    @Override
    public void await() throws ImportFailedException {
        try {
            this.awaitInternal();
            this.succeeded = true;
        }
        catch (Exception cause) {
            this.importFailedException = new ImportFailedException((Throwable)cause);
            throw this.importFailedException;
        }
    }

    @Override
    public void onStageReady(String jobId) {
        TransportExtensionUtils.validateReceivedJobId(jobId, this.job);
        LOGGER.info("Received StageReady signal for coordinated write. Notifying Sidecars. jobId={}", (Object)jobId);
        this.stageReady.complete(RestoreJobStatus.STAGE_READY);
    }

    @Override
    public void onImportReady(String jobId) {
        TransportExtensionUtils.validateReceivedJobId(jobId, this.job);
        LOGGER.info("Received ImportReady signal for coordinated write. Notifying Sidecars. jobId={}", (Object)jobId);
        this.importReady.complete(RestoreJobStatus.IMPORT_READY);
    }

    private void awaitInternal() {
        this.waitForStageReady();
        this.sendCoordinationSignal(RestoreJobStatus.STAGE_READY);
        this.pollForPhaseCompletion(this.stageCompletedClusters, (x$0, x$1) -> this.extension.onStageSucceeded((String)x$0, (long)x$1), (x$0, x$1) -> this.extension.onStageFailed((String)x$0, (Throwable)x$1));
        this.sendCoordinationSignal(RestoreJobStatus.STAGED);
        this.waitForImportReady();
        this.sendCoordinationSignal(RestoreJobStatus.IMPORT_READY);
        this.pollForPhaseCompletion(this.importCompletedClusters, (x$0, x$1) -> this.extension.onImportSucceeded((String)x$0, (long)x$1), (x$0, x$1) -> this.extension.onImportFailed((String)x$0, (Throwable)x$1));
    }

    private void waitForStageReady() {
        Preconditions.checkState((RestoreJobStatus.STAGE_READY == this.stageReady.join() ? 1 : 0) != 0);
    }

    private void waitForImportReady() {
        Preconditions.checkState((RestoreJobStatus.IMPORT_READY == this.importReady.join() ? 1 : 0) != 0);
    }

    private void pollForPhaseCompletion(Set<String> completedClusters, BiConsumer<String, Long> onClusterCompletion, BiConsumer<String, Throwable> failureHandler) throws ConsistencyNotSatisfiedException {
        RestoreJobStatus phase = this.determineReadyPhase();
        LOGGER.info("Polling restore job progress of clusters. phase={}", (Object)phase);
        while (completedClusters.size() < this.dataTransferApi.size()) {
            this.dataTransferApi.restoreJobProgress(RestoreJobProgressFetchPolicy.FIRST_FAILED, completedClusters::contains, (clusterId, progress) -> {
                if (this.checkProgressOfCluster((String)clusterId, (RestoreJobProgressResponsePayload)progress, completedClusters, failureHandler)) {
                    LOGGER.info("Restore job succeeded in the cluster. phase={} clusterId={}", (Object)phase, clusterId);
                    onClusterCompletion.accept((String)clusterId, this.elapsedMillis());
                }
            });
        }
    }

    private long elapsedMillis() {
        long nowNanos = System.nanoTime();
        long elapsedNanos = nowNanos - this.startTimeNanos;
        return TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
    }

    private void sendCoordinationSignal(RestoreJobStatus status) {
        LOGGER.info("Sending coordination singal to clusters. status={}", (Object)status);
        UpdateRestoreJobRequestPayload requestPayload = UpdateRestoreJobRequestPayload.builder().withStatus(status).build();
        this.dataTransferApi.updateRestoreJob(requestPayload);
    }

    private boolean checkProgressOfCluster(String clusterId, RestoreJobProgressResponsePayload progress, Set<String> completedClusters, BiConsumer<String, Throwable> failureHandler) throws ConsistencyNotSatisfiedException {
        if (progress.status() == ConsistencyVerificationResult.SATISFIED) {
            completedClusters.add(clusterId);
            return true;
        }
        if (progress.status() == ConsistencyVerificationResult.PENDING) {
            return false;
        }
        completedClusters.add(clusterId);
        String error = String.format("Some of the token ranges cannot satisfy with consistency level. job=%s phase=%s consistencyLevel=%s clusterId=%s ranges=%s", this.job.getRestoreJobId(clusterId), this.determineReadyPhase(), this.job.getConsistencyLevel(), clusterId, progress.failedRanges());
        LOGGER.error(error);
        ConsistencyNotSatisfiedException exception = new ConsistencyNotSatisfiedException(error);
        failureHandler.accept(clusterId, (Throwable)exception);
        throw exception;
    }

    private RestoreJobStatus determineReadyPhase() {
        if (this.importReady.isDone()) {
            return RestoreJobStatus.IMPORT_READY;
        }
        if (this.stageReady.isDone()) {
            return RestoreJobStatus.STAGE_READY;
        }
        return RestoreJobStatus.CREATED;
    }

    @VisibleForTesting
    boolean isStageReady() {
        if (this.stageReady.isDone()) {
            return RestoreJobStatus.STAGE_READY == this.stageReady.join();
        }
        return false;
    }

    @VisibleForTesting
    boolean isImportReady() {
        if (this.importReady.isDone()) {
            return RestoreJobStatus.IMPORT_READY == this.importReady.join();
        }
        return false;
    }
}

