/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.InetAddresses;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.spark.bulkwriter.BroadcastableTableSchema;
import org.apache.cassandra.spark.bulkwriter.TableSchema;
import org.apache.cassandra.spark.bulkwriter.TableSchemaTestCommon;
import org.apache.cassandra.spark.common.schema.ColumnType;
import org.apache.cassandra.spark.common.schema.ColumnTypes;
import org.apache.cassandra.spark.common.schema.ListType;
import org.apache.cassandra.spark.common.schema.MapType;
import org.apache.cassandra.spark.common.schema.SetType;
import org.apache.cassandra.spark.data.BridgeUdtValue;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TableSchemaNormalizeTest {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testAsciiNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "ascii", TableSchemaTestCommon.mockCqlType("ascii"), ColumnTypes.STRING, "ascii", "ascii", DataTypes.StringType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testBigIntNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "bigint", TableSchemaTestCommon.mockCqlType("bigint"), ColumnTypes.INT, 1, 1L, DataTypes.IntegerType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testBlobNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "blob", TableSchemaTestCommon.mockCqlType("blob"), ColumnTypes.BYTES, new byte[]{1, 1, 1, 1}, ByteBuffer.wrap(new byte[]{1, 1, 1, 1}), DataTypes.BinaryType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testBooleanNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "boolean", TableSchemaTestCommon.mockCqlType("boolean"), ColumnTypes.BOOLEAN, false, false, DataTypes.BooleanType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testDecimalNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "decimal", TableSchemaTestCommon.mockCqlType("decimal"), ColumnTypes.DOUBLE, BigDecimal.valueOf(1.1), BigDecimal.valueOf(1.1), (DataType)DataTypes.createDecimalType());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testDoubleNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "double", TableSchemaTestCommon.mockCqlType("double"), ColumnTypes.DOUBLE, 1.1, 1.1, DataTypes.DoubleType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testFloatNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "float", TableSchemaTestCommon.mockCqlType("float"), ColumnTypes.DOUBLE, Float.valueOf(1.1f), Float.valueOf(1.1f), DataTypes.FloatType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testInetNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "inet", TableSchemaTestCommon.mockCqlType("inet"), ColumnTypes.STRING, "192.168.1.1", InetAddresses.forString((String)"192.168.1.1"), DataTypes.StringType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testIntNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "int", TableSchemaTestCommon.mockCqlType("int"), ColumnTypes.INT, 1, 1, DataTypes.IntegerType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testTextNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "text", TableSchemaTestCommon.mockCqlType("text"), ColumnTypes.BYTES, "text", "text", DataTypes.StringType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testTimestampNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "timestamp", TableSchemaTestCommon.mockCqlType("timestamp"), ColumnTypes.LONG, new Date(1L), new Date(1L), DataTypes.DateType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testUuidNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "uuid", TableSchemaTestCommon.mockCqlType("uuid"), ColumnTypes.UUID, "382d3b34-22af-4b2a-97a3-ae7dbf9e6abe", UUID.fromString("382d3b34-22af-4b2a-97a3-ae7dbf9e6abe"), DataTypes.StringType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testVarcharNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "varchar", TableSchemaTestCommon.mockCqlType("varchar"), ColumnTypes.STRING, "varchar", "varchar", DataTypes.StringType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testVarIntNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "varint", TableSchemaTestCommon.mockCqlType("varint"), ColumnTypes.INT, "1", BigInteger.valueOf(1L), (DataType)DataTypes.createDecimalType((int)38, (int)0));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testTimeUuidNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "timeuuid", TableSchemaTestCommon.mockCqlType("timeuuid"), ColumnTypes.UUID, UUID.fromString("0846b690-ce35-11e7-8871-79b4d1aa8ef2"), UUID.fromString("0846b690-ce35-11e7-8871-79b4d1aa8ef2"), DataTypes.StringType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testSetNormalization(String cassandraVersion) {
        HashSet<String> set = new HashSet<String>();
        set.add("A");
        set.add("B");
        set.add("C");
        this.assertNormalized(cassandraVersion, "set", (CqlField.CqlType)TableSchemaTestCommon.mockSetCqlType("text"), (ColumnType<?>)new SetType(ColumnTypes.STRING), set, set, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testListNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "list", (CqlField.CqlType)TableSchemaTestCommon.mockListCqlType("int"), (ColumnType<?>)new ListType(ColumnTypes.INT), Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 3), (DataType)DataTypes.createArrayType((DataType)DataTypes.IntegerType));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testMapNormalization(String cassandraVersion) {
        Map<String, String> map = Stream.of(new AbstractMap.SimpleEntry<String, String>("Foo", "Bar")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.assertNormalized(cassandraVersion, "map", TableSchemaTestCommon.mockMapCqlType("text", "text"), (ColumnType<?>)new MapType(ColumnTypes.STRING, ColumnTypes.STRING), map, map, (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testSmallIntNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "smallint", TableSchemaTestCommon.mockCqlType("smallint"), ColumnTypes.INT, (short)2, (short)2, DataTypes.ShortType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testTinyIntNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "tiny", TableSchemaTestCommon.mockCqlType("tinyint"), ColumnTypes.INT, (byte)3, (byte)3, DataTypes.ByteType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testDateNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "date", TableSchemaTestCommon.mockCqlType("date"), ColumnTypes.LONG, new Date(2L), Integer.MIN_VALUE, DataTypes.DateType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testTimeNormalizationFromTimestamp(String cassandraVersion) {
        Timestamp timestamp = new Timestamp(0, 0, 0, 0, 0, 0, 3);
        this.assertNormalized(cassandraVersion, "time", TableSchemaTestCommon.mockCqlType("time"), ColumnTypes.LONG, timestamp, 3L, DataTypes.TimestampType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testTimeNormalizationFromLong(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "time", TableSchemaTestCommon.mockCqlType("time"), ColumnTypes.LONG, 7L, 7L, DataTypes.LongType);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testByteArrayListNormalization(String cassandraVersion) {
        this.assertNormalized(cassandraVersion, "byte_array_list", (CqlField.CqlType)TableSchemaTestCommon.mockListCqlType("blob"), (ColumnType<?>)new ListType(ColumnTypes.BYTES), Arrays.asList({1}, {2}, {3}), Arrays.asList(ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2}), ByteBuffer.wrap(new byte[]{3})), (DataType)DataTypes.createArrayType((DataType)DataTypes.BinaryType));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testByteArrayMapNormalization(String cassandraVersion) {
        byte[] bytes = new byte[]{66, 97, 114};
        Map<String, byte[]> source = Stream.of(new AbstractMap.SimpleEntry<String, byte[]>("Foo", bytes)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        Map<String, ByteBuffer> expected = Stream.of(new AbstractMap.SimpleEntry<String, ByteBuffer>("Foo", ByteBuffer.wrap(bytes))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        this.assertNormalized(cassandraVersion, "mapWithBytes", TableSchemaTestCommon.mockMapCqlType("text", "blob"), (ColumnType<?>)new MapType(ColumnTypes.STRING, ColumnTypes.STRING), source, expected, (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testByteArraySetNormalization(String cassandraVersion) {
        byte[] bytes = new byte[]{66, 97, 114};
        HashSet source = new HashSet(Arrays.asList(new byte[][]{bytes}));
        HashSet<ByteBuffer> expected = new HashSet<ByteBuffer>(Collections.singletonList(ByteBuffer.wrap(bytes)));
        this.assertNormalized(cassandraVersion, "setWithBytes", (CqlField.CqlType)TableSchemaTestCommon.mockSetCqlType("blob"), (ColumnType<?>)new SetType(ColumnTypes.BYTES), source, expected, (DataType)DataTypes.createArrayType((DataType)DataTypes.BinaryType));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testNestedNormalization(String cassandraVersion) {
        byte[] bytes = new byte[]{66, 97, 114};
        HashMap<String, List<Set>> source = new HashMap<String, List<Set>>();
        source.put("Foo1", Arrays.asList(new HashSet(Arrays.asList(new byte[][]{bytes})), new HashSet(Arrays.asList(new byte[][]{bytes}))));
        source.put("Foo2", Arrays.asList(new HashSet(Arrays.asList(new byte[][]{bytes})), new HashSet(Arrays.asList(new byte[][]{bytes}))));
        HashMap<String, List<Set>> expected = new HashMap<String, List<Set>>();
        expected.put("Foo1", Arrays.asList(new HashSet<ByteBuffer>(Collections.singletonList(ByteBuffer.wrap(bytes))), new HashSet<ByteBuffer>(Collections.singletonList(ByteBuffer.wrap(bytes)))));
        expected.put("Foo2", Arrays.asList(new HashSet<ByteBuffer>(Collections.singletonList(ByteBuffer.wrap(bytes))), new HashSet<ByteBuffer>(Collections.singletonList(ByteBuffer.wrap(bytes)))));
        CqlField.CqlMap cqlType = TableSchemaTestCommon.mockMapCqlType(TableSchemaTestCommon.mockCqlType("text"), (CqlField.CqlType)TableSchemaTestCommon.mockCollectionCqlType("list", (CqlField.CqlType)TableSchemaTestCommon.mockCollectionCqlType("set", TableSchemaTestCommon.mockCqlType("blob"))));
        this.assertNormalized(cassandraVersion, "byte_array_list", (CqlField.CqlType)cqlType, (ColumnType<?>)new MapType(ColumnTypes.STRING, (ColumnType)new ListType(ColumnTypes.BYTES)), source, expected, (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.createArrayType((DataType)DataTypes.createArrayType((DataType)DataTypes.BinaryType))));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#supportedVersions"})
    public void testUdtNormalization(String cassandraVersion) {
        StructType structType = new StructType().add(new StructField("f1", DataTypes.IntegerType, false, Metadata.empty())).add(new StructField("f2", DataTypes.StringType, false, Metadata.empty()));
        GenericRowWithSchema source = new GenericRowWithSchema(new Object[]{1, "course"}, structType);
        BridgeUdtValue udtValue = new BridgeUdtValue("udt_field", (Map)ImmutableMap.of((Object)"f1", (Object)1, (Object)"f2", (Object)"course"));
        CqlField.CqlUdt cqlType = TableSchemaTestCommon.mockUdtCqlType("udt_field", "f1", "int", "f2", "text");
        this.assertNormalized(cassandraVersion, "udt_field", (CqlField.CqlType)cqlType, (ColumnType<?>)new MapType(ColumnTypes.STRING, (ColumnType)new ListType(ColumnTypes.BYTES)), source, udtValue, (DataType)structType);
    }

    private void assertNormalized(String cassandraVersion, String field, CqlField.CqlType cqlType, ColumnType<?> columnType, Object sourceVal, Object expectedVal, DataType sparkType) {
        DataType[] sparkTypes = new DataType[]{sparkType};
        String[] fieldNames = new String[]{field};
        ColumnType[] cqlTypes = new ColumnType[]{columnType};
        TableSchema schema = TableSchemaTestCommon.buildSchema(cassandraVersion, fieldNames, sparkTypes, new CqlField.CqlType[]{cqlType}, fieldNames, cqlTypes, fieldNames);
        BroadcastableTableSchema broadcastable = BroadcastableTableSchema.from((TableSchema)schema);
        Object[] source = new Object[]{sourceVal};
        Object[] expected = new Object[]{expectedVal};
        Object[] normalized = broadcastable.normalize(source);
        MatcherAssert.assertThat((Object)normalized, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)expected)));
    }
}

