/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.validation;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cassandra.spark.validation.StartupValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartupValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartupValidator.class);
    private static final ThreadLocal<StartupValidator> INSTANCE = ThreadLocal.withInitial(StartupValidator::new);
    private static final String DISABLE = "SKIP_STARTUP_VALIDATIONS";
    private final List<StartupValidation> validations = new CopyOnWriteArrayList<StartupValidation>();

    private StartupValidator() {
    }

    public static StartupValidator instance() {
        return INSTANCE.get();
    }

    public void register(StartupValidation validation) {
        this.validations.add(validation);
    }

    @VisibleForTesting
    void reset() {
        this.validations.clear();
    }

    public void perform() {
        StringBuilder message = new StringBuilder(1024);
        boolean passed = true;
        if (this.enabled()) {
            message.append("Performed startup validations:");
            for (StartupValidation validation : this.validations) {
                String name = validation.getClass().getCanonicalName();
                message.append(System.lineSeparator() + " * " + name + ": ");
                Throwable result = validation.perform();
                if (result == null) {
                    LOGGER.debug("Passed startup validation with " + name);
                    message.append("PASSED");
                    continue;
                }
                LOGGER.error("Failed startup validation with " + name, result);
                message.append("FAILED");
                passed = false;
            }
        } else {
            message.append("Skipped startup validations");
        }
        this.reset();
        if (!passed) {
            LOGGER.error(message.toString());
            throw new RuntimeException("Failed some of startup validations");
        }
        LOGGER.info(message.toString());
    }

    public boolean enabled() {
        return !"true".equalsIgnoreCase(System.getProperty(DISABLE));
    }
}

