/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.shrink;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.TestUninterruptibles;
import org.apache.cassandra.analytics.shrink.LeavingTestBase;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class LeavingHalfTest
extends LeavingTestBase {
    LeavingHalfTest() {
    }

    @ParameterizedTest(name="{index} => {0}")
    @MethodSource(value={"singleDCTestInputs"})
    void halveClusterSize(TestConsistencyLevel cl) {
        this.runLeavingTestScenario(cl);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3);
        LeavingHalfTest.singleDCTestInputs().forEach(arguments -> {
            QualifiedName tableName = LeavingHalfTest.uniqueTestTableFullName("spark_test", arguments.get());
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    protected void beforeClusterShutdown() {
        this.completeTransitionsAndValidateWrites(BBHelperHalveClusterSize.transitionalStateEnd, LeavingHalfTest.singleDCTestInputs());
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return LeavingHalfTest.clusterConfig().nodesPerDc(6).requestFeature(Feature.NETWORK).instanceInitializer(BBHelperHalveClusterSize::install);
    }

    @Override
    protected int leavingNodesPerDc() {
        return 3;
    }

    @Override
    protected CountDownLatch transitioningStateStart() {
        return BBHelperHalveClusterSize.transitionalStateStart;
    }

    public static class BBHelperHalveClusterSize {
        static final CountDownLatch transitionalStateStart = new CountDownLatch(3);
        static final CountDownLatch transitionalStateEnd = new CountDownLatch(3);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber > 3) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.StorageService").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"unbootstrap")).intercept((Implementation)MethodDelegation.to(BBHelperHalveClusterSize.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static void unbootstrap(@SuperCall Callable<?> orig) throws Exception {
            transitionalStateStart.countDown();
            TestUninterruptibles.awaitUninterruptiblyOrThrow(transitionalStateEnd, 2L, TimeUnit.MINUTES);
            orig.call();
        }
    }
}

