/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationFactor
implements Serializable {
    public static final Serializer SERIALIZER = new Serializer();
    private static final long serialVersionUID = -2017022813595983257L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationFactor.class);
    @NotNull
    private final ReplicationStrategy replicationStrategy;
    @NotNull
    private final Map<String, Integer> options;

    public static ReplicationFactor simpleStrategy(int rf) {
        return new ReplicationFactor(ReplicationStrategy.SimpleStrategy, (Map<String, Integer>)ImmutableMap.of((Object)"replication_factor", (Object)rf));
    }

    public ReplicationFactor(@NotNull Map<String, String> options) {
        this.replicationStrategy = ReplicationStrategy.getEnum(options.get("class"));
        this.options = new LinkedHashMap<String, Integer>(options.size());
        for (Map.Entry<String, String> entry : options.entrySet()) {
            if ("class".equals(entry.getKey())) continue;
            try {
                this.options.put(entry.getKey(), Integer.parseInt(entry.getValue()));
            }
            catch (NumberFormatException exception) {
                LOGGER.warn("Could not parse replication option: {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    public ReplicationFactor(@NotNull ReplicationStrategy replicationStrategy, @NotNull Map<String, Integer> options) {
        this.replicationStrategy = replicationStrategy;
        this.options = new LinkedHashMap<String, Integer>(options.size());
        if (!replicationStrategy.equals((Object)ReplicationStrategy.LocalStrategy) && options.isEmpty()) {
            throw new RuntimeException(String.format("Could not find replication info in schema map: %s.", options));
        }
        for (Map.Entry<String, Integer> entry : options.entrySet()) {
            if ("class".equals(entry.getKey())) continue;
            this.options.put(entry.getKey(), entry.getValue());
        }
    }

    public Integer getTotalReplicationFactor() {
        return this.options.values().stream().mapToInt(Integer::intValue).sum();
    }

    @NotNull
    public Map<String, Integer> getOptions() {
        return this.options;
    }

    @NotNull
    public ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ReplicationFactor that = (ReplicationFactor)other;
        return this.replicationStrategy == that.replicationStrategy && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.replicationStrategy, this.options});
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<ReplicationFactor> {
        public void write(Kryo kryo, Output out, ReplicationFactor replicationFactor) {
            out.writeByte(replicationFactor.replicationStrategy.value);
            out.writeByte(replicationFactor.options.size());
            for (Map.Entry<String, Integer> entry : replicationFactor.options.entrySet()) {
                out.writeString(entry.getKey());
                out.writeByte(entry.getValue().intValue());
            }
        }

        public ReplicationFactor read(Kryo kryo, Input in, Class<ReplicationFactor> type) {
            ReplicationStrategy strategy = ReplicationStrategy.valueOf(in.readByte());
            int numOptions = in.readByte();
            HashMap<String, Integer> options = new HashMap<String, Integer>(numOptions);
            for (int option = 0; option < numOptions; ++option) {
                options.put(in.readString(), Integer.valueOf(in.readByte()));
            }
            return new ReplicationFactor(strategy, options);
        }
    }

    public static enum ReplicationStrategy {
        LocalStrategy(0),
        SimpleStrategy(1),
        NetworkTopologyStrategy(2);

        public final int value;

        private ReplicationStrategy(int value) {
            this.value = value;
        }

        public static ReplicationStrategy valueOf(int value) {
            switch (value) {
                case 0: {
                    return LocalStrategy;
                }
                case 1: {
                    return SimpleStrategy;
                }
                case 2: {
                    return NetworkTopologyStrategy;
                }
            }
            throw new IllegalStateException("Unknown ReplicationStrategy: " + value);
        }

        public static ReplicationStrategy getEnum(String value) {
            for (ReplicationStrategy v : ReplicationStrategy.values()) {
                if (!value.equalsIgnoreCase(v.name()) && !value.endsWith("." + v.name())) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }
    }
}

