/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupComplete;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupHistory;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupSession;
import org.apache.cassandra.service.paxos.cleanup.PaxosFinishPrepareCleanup;
import org.apache.cassandra.service.paxos.cleanup.PaxosStartPrepareCleanup;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosCleanup
extends AsyncFuture<Void>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PaxosCleanup.class);
    private final SharedContext ctx;
    private final Collection<InetAddressAndPort> endpoints;
    private final TableMetadata table;
    private final Collection<Range<Token>> ranges;
    private final boolean skippedReplicas;
    private final Executor executor;
    private PaxosStartPrepareCleanup startPrepare;
    private PaxosFinishPrepareCleanup finishPrepare;
    private PaxosCleanupSession session;
    private PaxosCleanupComplete complete;

    public PaxosCleanup(SharedContext ctx, Collection<InetAddressAndPort> endpoints, TableMetadata table, Collection<Range<Token>> ranges, boolean skippedReplicas, Executor executor) {
        this.ctx = ctx;
        this.endpoints = endpoints;
        this.table = table;
        this.ranges = ranges;
        this.skippedReplicas = skippedReplicas;
        this.executor = executor;
    }

    private <T> void addCallback(Future<T> future, Consumer<T> onComplete) {
        future.addCallback(onComplete, this::tryFailure);
    }

    public static PaxosCleanup cleanup(SharedContext ctx, Collection<InetAddressAndPort> endpoints, TableMetadata table, Collection<Range<Token>> ranges, boolean skippedReplicas, Executor executor) {
        PaxosCleanup cleanup = new PaxosCleanup(ctx, endpoints, table, ranges, skippedReplicas, executor);
        executor.execute(cleanup);
        return cleanup;
    }

    @Override
    public void run() {
        EndpointState localEpState = this.ctx.gossiper().getEndpointStateForEndpoint(this.ctx.broadcastAddressAndPort());
        this.startPrepare = PaxosStartPrepareCleanup.prepare(this.ctx, this.table.id, this.endpoints, localEpState, this.ranges);
        this.addCallback(this.startPrepare, this::finishPrepare);
    }

    private void finishPrepare(PaxosCleanupHistory result) {
        this.ctx.nonPeriodicTasks().schedule(() -> {
            this.finishPrepare = PaxosFinishPrepareCleanup.finish(this.ctx, this.endpoints, result);
            this.addCallback(this.finishPrepare, (T v) -> this.startSession(result.highBound));
        }, Math.min(DatabaseDescriptor.getCasContentionTimeout(TimeUnit.MILLISECONDS), DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.MILLISECONDS)), TimeUnit.MILLISECONDS);
    }

    private void startSession(Ballot lowBound) {
        this.session = new PaxosCleanupSession(this.ctx, this.endpoints, this.table.id, this.ranges);
        this.addCallback(this.session, (T v) -> this.finish(lowBound));
        this.executor.execute(this.session);
    }

    private void finish(Ballot lowBound) {
        this.complete = new PaxosCleanupComplete(this.ctx, this.endpoints, this.table.id, this.ranges, lowBound, this.skippedReplicas);
        this.addCallback(this.complete, this::trySuccess);
        this.executor.execute(this.complete);
    }

    private static boolean isOutOfRange(SharedContext ctx, String ksName, Collection<Range<Token>> repairRanges) {
        Keyspace keyspace = Keyspace.open(ksName);
        List localRanges = Range.normalize(keyspace.getReplicationStrategy().getAddressReplicas().get(ctx.broadcastAddressAndPort()).ranges());
        RangesAtEndpoint pendingRanges = StorageService.instance.getTokenMetadata().getPendingRanges(ksName, ctx.broadcastAddressAndPort());
        if (!pendingRanges.isEmpty()) {
            localRanges.addAll(pendingRanges.ranges());
            localRanges = Range.normalize(localRanges);
        }
        for (Range repairRange : Range.normalize(repairRanges)) {
            if (Iterables.any(localRanges, localRange -> localRange.contains(repairRange))) continue;
            return true;
        }
        return false;
    }

    static boolean isInRangeAndShouldProcess(SharedContext ctx, Collection<Range<Token>> ranges, TableId tableId) {
        TableMetadata metadata = Schema.instance.getTableMetadata(tableId);
        Keyspace keyspace = Keyspace.open(metadata.keyspace);
        Preconditions.checkNotNull((Object)keyspace);
        if (!PaxosCleanup.isOutOfRange(ctx, metadata.keyspace, ranges)) {
            return true;
        }
        logger.warn("Out of range PaxosCleanup request for {}: {}", (Object)metadata, ranges);
        return false;
    }
}

