/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public abstract class AbstractConditionExpressionRule
implements IAlgebraicRewriteRule {
    private IOptimizationContext context;

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        Mutable condRef;
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        switch (op.getOperatorTag()) {
            case SELECT: {
                SelectOperator select = (SelectOperator)op;
                condRef = select.getCondition();
                break;
            }
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op;
                condRef = join.getCondition();
                break;
            }
            default: {
                return false;
            }
        }
        this.context = context;
        boolean changed = this.transform((Mutable<ILogicalExpression>)condRef);
        if (changed) {
            context.computeAndSetTypeEnvironmentForOperator(op);
        }
        return changed;
    }

    protected final AbstractFunctionCallExpression getFunctionExpression(ILogicalExpression expression) {
        if (expression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        return (AbstractFunctionCallExpression)expression;
    }

    protected final IFunctionInfo getFunctionInfo(FunctionIdentifier fid) {
        return this.context.getMetadataProvider().lookupFunction(fid);
    }

    protected abstract boolean transform(Mutable<ILogicalExpression> var1);
}

