/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.util;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MutableArrayValueReference MARKER_LSN_KEY = new MutableArrayValueReference("Marker".getBytes());
    public static final long NOT_FOUND = -1L;

    private ComponentUtils() {
    }

    public static long getLong(IComponentMetadata metadata, IValueReference key, long defaultValue, ArrayBackedValueStorage value) throws HyracksDataException {
        metadata.get(key, value);
        return value.getLength() == 0 ? defaultValue : LongPointable.getLong((byte[])value.getByteArray(), (int)value.getStartOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(ILSMIndex index, IValueReference key, ArrayBackedValueStorage value) throws HyracksDataException {
        value.reset();
        ILSMOperationTracker iLSMOperationTracker = index.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            ILSMMemoryComponent cmc = index.getCurrentMemoryComponent();
            if (cmc.isReadable()) {
                index.getCurrentMemoryComponent().getMetadata().get(key, value);
            }
            if (value.getLength() == 0) {
                ComponentUtils.fromImmutableMemoryComponents(index, key, value);
                if (value.getLength() == 0) {
                    ComponentUtils.fromDiskComponents(index, key, value);
                    if (value.getLength() == 0) {
                        LOGGER.debug("{} was NOT found", (Object)key);
                    }
                }
            } else {
                LOGGER.debug("{} was found in mutable memory component {}", (Object)key, (Object)cmc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ILSMIndex index, IValueReference key, IPointable pointable) throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = index.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            index.getCurrentMemoryComponent().getMetadata().put(key, (IValueReference)pointable);
        }
    }

    private static void fromDiskComponents(ILSMIndex index, IValueReference key, ArrayBackedValueStorage value) throws HyracksDataException {
        for (ILSMDiskComponent c : index.getDiskComponents()) {
            c.getMetadata().get(key, value);
            if (value.getLength() == 0) continue;
            LOGGER.debug("{} was found in disk component {}", (Object)key, (Object)c);
            return;
        }
    }

    private static void fromImmutableMemoryComponents(ILSMIndex index, IValueReference key, ArrayBackedValueStorage value) throws HyracksDataException {
        List<ILSMMemoryComponent> memComponents = index.getMemoryComponents();
        int numOtherMemComponents = memComponents.size() - 1;
        int next = index.getCurrentMemoryComponentIndex();
        for (int i = 0; i < numOtherMemComponents; ++i) {
            ILSMMemoryComponent c;
            if (--next < 0) {
                next = memComponents.size() - 1;
            }
            if (!(c = index.getMemoryComponents().get(next)).isReadable()) continue;
            c.getMetadata().get(key, value);
            if (value.getLength() == 0) continue;
            LOGGER.debug("{} was found in immutable memory component {}", (Object)key, (Object)c);
            return;
        }
    }

    public static void markAsValid(ITreeIndex treeIndex, boolean forceToDisk, IPageWriteFailureCallback callback) throws HyracksDataException {
        int fileId = treeIndex.getFileId();
        IBufferCache bufferCache = treeIndex.getBufferCache();
        treeIndex.getPageManager().close(callback);
        if (callback.hasFailed()) {
            throw HyracksDataException.create((Throwable)callback.getFailure());
        }
        if (forceToDisk) {
            bufferCache.force(fileId, true);
        }
    }

    public static void markAsValid(IBufferCache bufferCache, BloomFilter filter, boolean forceToDisk) throws HyracksDataException {
        if (forceToDisk) {
            bufferCache.force(filter.getFileId(), true);
        }
    }
}

