% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adbcsqlite-package.R
\name{adbcsqlite}
\alias{adbcsqlite}
\alias{adbc_database_init.adbcsqlite_driver_sqlite}
\alias{adbc_connection_init.adbcsqlite_database}
\alias{adbc_statement_init.adbcsqlite_connection}
\title{ADBC SQLite3 Driver}
\usage{
adbcsqlite()

\method{adbc_database_init}{adbcsqlite_driver_sqlite}(driver, ..., uri = ":memory:")

\method{adbc_connection_init}{adbcsqlite_database}(database, ..., adbc.connection.autocommit = NULL)

\method{adbc_statement_init}{adbcsqlite_connection}(
  connection,
  ...,
  adbc.ingest.target_table = NULL,
  adbc.ingest.target_catalog = NULL,
  adbc.ingest.mode = NULL,
  adbc.sqlite.query.batch_rows = NULL
)
}
\arguments{
\item{driver}{An \code{\link[adbcdrivermanager:adbc_driver]{adbc_driver()}}.}

\item{...}{Driver-specific options. For the default method, these are
named values that are converted to strings.}

\item{uri}{A URI to a database path or ":memory:" for an in-memory database.}

\item{database}{An \link[adbcdrivermanager:adbc_database_init]{adbc_database}.}

\item{adbc.connection.autocommit}{Use FALSE to disable the default
autocommit behaviour.}

\item{connection}{An \link[adbcdrivermanager:adbc_connection_init]{adbc_connection}}

\item{adbc.ingest.target_table}{The name of the target table for a bulk insert.}

\item{adbc.ingest.target_catalog}{The catalog of the table for a bulk insert.}

\item{adbc.ingest.mode}{Whether to create (the default) or append.}

\item{adbc.sqlite.query.batch_rows}{The number of rows per batch to return.}
}
\value{
An \code{\link[adbcdrivermanager:adbc_driver_void]{adbcdrivermanager::adbc_driver()}}
}
\description{
ADBC SQLite3 Driver
}
\examples{
adbcsqlite()

}
