/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { FC } from 'react';
import { Nav } from 'react-bootstrap';
import { NavLink, useLocation } from 'react-router-dom';
import { useTranslation } from 'react-i18next';

const TabNav: FC<{ menus: { name: string; path: string }[] }> = ({ menus }) => {
  const { t } = useTranslation('translation', { keyPrefix: 'nav_menus' });
  const { pathname } = useLocation();
  return (
    <Nav variant="underline" className="mb-4 border-bottom">
      {menus.map((menu) => (
        <Nav.Item key={menu.path}>
          <NavLink
            to={menu.path}
            className={() =>
              pathname === menu.path ? 'nav-link active' : 'nav-link'
            }>
            {t(menu.name)}
          </NavLink>
        </Nav.Item>
      ))}
    </Nav>
  );
};

export default TabNav;
