/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsAbstractResourceId;
import org.apache.qpid.jms.meta.JmsConnectionId;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsProducerId;

public final class JmsSessionId
extends JmsAbstractResourceId
implements Comparable<JmsSessionId> {
    private final String connectionId;
    private final long value;
    private transient String key;
    private transient JmsConnectionId parentId;

    public JmsSessionId(String connectionId, long value) {
        if (connectionId == null || connectionId.isEmpty()) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        this.connectionId = connectionId;
        this.value = value;
    }

    public JmsSessionId(JmsConnectionId connectionId, long sessionId) {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        this.connectionId = connectionId.getValue();
        this.value = sessionId;
        this.parentId = connectionId;
    }

    public JmsSessionId(JmsSessionId id) {
        if (id == null) {
            throw new IllegalArgumentException("Session ID cannot be null");
        }
        this.connectionId = id.getConnectionId();
        this.value = id.getValue();
    }

    public JmsSessionId(JmsProducerId id) {
        if (id == null) {
            throw new IllegalArgumentException("Producer ID cannot be null");
        }
        this.connectionId = id.getConnectionId();
        this.value = id.getSessionId();
    }

    public JmsSessionId(JmsConsumerId id) {
        if (id == null) {
            throw new IllegalArgumentException("Consumer ID cannot be null");
        }
        this.connectionId = id.getConnectionId();
        this.value = id.getSessionId();
    }

    public JmsConnectionId getParentId() {
        if (this.parentId == null) {
            this.parentId = new JmsConnectionId(this);
        }
        return this.parentId;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = 31 * this.hashCode + this.connectionId.hashCode();
            this.hashCode = 31 * this.hashCode + (int)(this.value ^ this.value >>> 32);
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != JmsSessionId.class) {
            return false;
        }
        JmsSessionId id = (JmsSessionId)o;
        return this.value == id.value && this.connectionId.equals(id.connectionId);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.connectionId + ":" + this.value;
        }
        return this.key;
    }

    @Override
    public int compareTo(JmsSessionId other) {
        return this.toString().compareTo(other.toString());
    }
}

